/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse;

public class GetChangeLogsPublisher
implements SdkPublisher<GetChangeLogsResponse> {
    private final AuditManagerAsyncClient client;
    private final GetChangeLogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetChangeLogsPublisher(AuditManagerAsyncClient client, GetChangeLogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetChangeLogsPublisher(AuditManagerAsyncClient client, GetChangeLogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetChangeLogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetChangeLogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetChangeLogsResponseFetcher
    implements AsyncPageFetcher<GetChangeLogsResponse> {
        private GetChangeLogsResponseFetcher() {
        }

        public boolean hasNextPage(GetChangeLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetChangeLogsResponse> nextPage(GetChangeLogsResponse previousPage) {
            if (previousPage == null) {
                return GetChangeLogsPublisher.this.client.getChangeLogs(GetChangeLogsPublisher.this.firstRequest);
            }
            return GetChangeLogsPublisher.this.client.getChangeLogs((GetChangeLogsRequest)((Object)GetChangeLogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

