/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse;

public class GetEvidenceFoldersByAssessmentPublisher
implements SdkPublisher<GetEvidenceFoldersByAssessmentResponse> {
    private final AuditManagerAsyncClient client;
    private final GetEvidenceFoldersByAssessmentRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEvidenceFoldersByAssessmentPublisher(AuditManagerAsyncClient client, GetEvidenceFoldersByAssessmentRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEvidenceFoldersByAssessmentPublisher(AuditManagerAsyncClient client, GetEvidenceFoldersByAssessmentRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEvidenceFoldersByAssessmentResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEvidenceFoldersByAssessmentResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEvidenceFoldersByAssessmentResponseFetcher
    implements AsyncPageFetcher<GetEvidenceFoldersByAssessmentResponse> {
        private GetEvidenceFoldersByAssessmentResponseFetcher() {
        }

        public boolean hasNextPage(GetEvidenceFoldersByAssessmentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEvidenceFoldersByAssessmentResponse> nextPage(GetEvidenceFoldersByAssessmentResponse previousPage) {
            if (previousPage == null) {
                return GetEvidenceFoldersByAssessmentPublisher.this.client.getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentPublisher.this.firstRequest);
            }
            return GetEvidenceFoldersByAssessmentPublisher.this.client.getEvidenceFoldersByAssessment((GetEvidenceFoldersByAssessmentRequest)((Object)GetEvidenceFoldersByAssessmentPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

