/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Resource.getter(Resource::arn)).setter(Resource.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(Resource.getter(Resource::value)).setter(Resource.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> COMPLIANCE_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceCheck").getter(Resource.getter(Resource::complianceCheck)).setter(Resource.setter(Builder::complianceCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VALUE_FIELD, COMPLIANCE_CHECK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String value;
    private final String complianceCheck;

    private Resource(BuilderImpl builder) {
        this.arn = builder.arn;
        this.value = builder.value;
        this.complianceCheck = builder.complianceCheck;
    }

    public final String arn() {
        return this.arn;
    }

    public final String value() {
        return this.value;
    }

    public final String complianceCheck() {
        return this.complianceCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.complianceCheck(), other.complianceCheck());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Arn", (Object)this.arn()).add("Value", (Object)this.value()).add("ComplianceCheck", (Object)this.complianceCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "complianceCheck": {
                return Optional.ofNullable(clazz.cast(this.complianceCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String value;
        private String complianceCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.arn(model.arn);
            this.value(model.value);
            this.complianceCheck(model.complianceCheck);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getComplianceCheck() {
            return this.complianceCheck;
        }

        public final void setComplianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
        }

        @Override
        public final Builder complianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder arn(String var1);

        public Builder value(String var1);

        public Builder complianceCheck(String var1);
    }
}

