/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.AWSAccount;
import software.amazon.awssdk.services.auditmanager.model.AssessmentFramework;
import software.amazon.awssdk.services.auditmanager.model.AssessmentMetadata;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Assessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Assessment> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Assessment.getter(Assessment::arn)).setter(Assessment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<AWSAccount> AWS_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsAccount").getter(Assessment.getter(Assessment::awsAccount)).setter(Assessment.setter(Builder::awsAccount)).constructor(AWSAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()}).build();
    private static final SdkField<AssessmentMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(Assessment.getter(Assessment::metadata)).setter(Assessment.setter(Builder::metadata)).constructor(AssessmentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<AssessmentFramework> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("framework").getter(Assessment.getter(Assessment::framework)).setter(Assessment.setter(Builder::framework)).constructor(AssessmentFramework::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Assessment.getter(Assessment::tags)).setter(Assessment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_ACCOUNT_FIELD, METADATA_FIELD, FRAMEWORK_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final AWSAccount awsAccount;
    private final AssessmentMetadata metadata;
    private final AssessmentFramework framework;
    private final Map<String, String> tags;

    private Assessment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsAccount = builder.awsAccount;
        this.metadata = builder.metadata;
        this.framework = builder.framework;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final AWSAccount awsAccount() {
        return this.awsAccount;
    }

    public final AssessmentMetadata metadata() {
        return this.metadata;
    }

    public final AssessmentFramework framework() {
        return this.framework;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.awsAccount(), other.awsAccount()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.framework(), other.framework()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Assessment").add("Arn", (Object)this.arn()).add("AwsAccount", (Object)this.awsAccount()).add("Metadata", (Object)this.metadata()).add("Framework", (Object)(this.framework() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "awsAccount": {
                return Optional.ofNullable(clazz.cast(this.awsAccount()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Assessment, T> g) {
        return obj -> g.apply((Assessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private AWSAccount awsAccount;
        private AssessmentMetadata metadata;
        private AssessmentFramework framework;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Assessment model) {
            this.arn(model.arn);
            this.awsAccount(model.awsAccount);
            this.metadata(model.metadata);
            this.framework(model.framework);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AWSAccount.Builder getAwsAccount() {
            return this.awsAccount != null ? this.awsAccount.toBuilder() : null;
        }

        public final void setAwsAccount(AWSAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        @Override
        public final Builder awsAccount(AWSAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final AssessmentMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(AssessmentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(AssessmentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final AssessmentFramework.Builder getFramework() {
            return this.framework != null ? this.framework.toBuilder() : null;
        }

        public final void setFramework(AssessmentFramework.BuilderImpl framework) {
            this.framework = framework != null ? framework.build() : null;
        }

        @Override
        public final Builder framework(AssessmentFramework framework) {
            this.framework = framework;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Assessment build() {
            return new Assessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Assessment> {
        public Builder arn(String var1);

        public Builder awsAccount(AWSAccount var1);

        default public Builder awsAccount(Consumer<AWSAccount.Builder> awsAccount) {
            return this.awsAccount((AWSAccount)((AWSAccount.Builder)AWSAccount.builder().applyMutation(awsAccount)).build());
        }

        public Builder metadata(AssessmentMetadata var1);

        default public Builder metadata(Consumer<AssessmentMetadata.Builder> metadata) {
            return this.metadata((AssessmentMetadata)((AssessmentMetadata.Builder)AssessmentMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder framework(AssessmentFramework var1);

        default public Builder framework(Consumer<AssessmentFramework.Builder> framework) {
            return this.framework((AssessmentFramework)((AssessmentFramework.Builder)AssessmentFramework.builder().applyMutation(framework)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

