/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse;

public class ListKeywordsForDataSourceIterable
implements SdkIterable<ListKeywordsForDataSourceResponse> {
    private final AuditManagerClient client;
    private final ListKeywordsForDataSourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeywordsForDataSourceIterable(AuditManagerClient client, ListKeywordsForDataSourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKeywordsForDataSourceResponseFetcher();
    }

    public Iterator<ListKeywordsForDataSourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKeywordsForDataSourceResponseFetcher
    implements SyncPageFetcher<ListKeywordsForDataSourceResponse> {
        private ListKeywordsForDataSourceResponseFetcher() {
        }

        public boolean hasNextPage(ListKeywordsForDataSourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKeywordsForDataSourceResponse nextPage(ListKeywordsForDataSourceResponse previousPage) {
            if (previousPage == null) {
                return ListKeywordsForDataSourceIterable.this.client.listKeywordsForDataSource(ListKeywordsForDataSourceIterable.this.firstRequest);
            }
            return ListKeywordsForDataSourceIterable.this.client.listKeywordsForDataSource((ListKeywordsForDataSourceRequest)((Object)ListKeywordsForDataSourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

