/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEvidenceRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, GetEvidenceRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(GetEvidenceRequest.getter(GetEvidenceRequest::assessmentId)).setter(GetEvidenceRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(GetEvidenceRequest.getter(GetEvidenceRequest::controlSetId)).setter(GetEvidenceRequest.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()}).build();
    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceFolderId").getter(GetEvidenceRequest.getter(GetEvidenceRequest::evidenceFolderId)).setter(GetEvidenceRequest.setter(Builder::evidenceFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("evidenceFolderId").build()}).build();
    private static final SdkField<String> EVIDENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceId").getter(GetEvidenceRequest.getter(GetEvidenceRequest::evidenceId)).setter(GetEvidenceRequest.setter(Builder::evidenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("evidenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, CONTROL_SET_ID_FIELD, EVIDENCE_FOLDER_ID_FIELD, EVIDENCE_ID_FIELD));
    private final String assessmentId;
    private final String controlSetId;
    private final String evidenceFolderId;
    private final String evidenceId;

    private GetEvidenceRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.evidenceId = builder.evidenceId;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String evidenceFolderId() {
        return this.evidenceFolderId;
    }

    public final String evidenceId() {
        return this.evidenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceRequest)) {
            return false;
        }
        GetEvidenceRequest other = (GetEvidenceRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.evidenceFolderId(), other.evidenceFolderId()) && Objects.equals(this.evidenceId(), other.evidenceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetEvidenceRequest").add("AssessmentId", (Object)this.assessmentId()).add("ControlSetId", (Object)this.controlSetId()).add("EvidenceFolderId", (Object)this.evidenceFolderId()).add("EvidenceId", (Object)this.evidenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "evidenceFolderId": {
                return Optional.ofNullable(clazz.cast(this.evidenceFolderId()));
            }
            case "evidenceId": {
                return Optional.ofNullable(clazz.cast(this.evidenceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceRequest, T> g) {
        return obj -> g.apply((GetEvidenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String controlSetId;
        private String evidenceFolderId;
        private String evidenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.controlSetId(model.controlSetId);
            this.evidenceFolderId(model.evidenceFolderId);
            this.evidenceId(model.evidenceId);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getEvidenceFolderId() {
            return this.evidenceFolderId;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        @Override
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final String getEvidenceId() {
            return this.evidenceId;
        }

        public final void setEvidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
        }

        @Override
        public final Builder evidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEvidenceRequest build() {
            return new GetEvidenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEvidenceRequest> {
        public Builder assessmentId(String var1);

        public Builder controlSetId(String var1);

        public Builder evidenceFolderId(String var1);

        public Builder evidenceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

