/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Evidence that's manually added to a control in Audit Manager. <code>manualEvidence</code> can be one of the
 * following: <code>evidenceFileName</code>, <code>s3ResourcePath</code>, or <code>textResponse</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManualEvidence implements SdkPojo, Serializable, ToCopyableBuilder<ManualEvidence.Builder, ManualEvidence> {
    private static final SdkField<String> S3_RESOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ResourcePath").getter(getter(ManualEvidence::s3ResourcePath)).setter(setter(Builder::s3ResourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourcePath").build()).build();

    private static final SdkField<String> TEXT_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textResponse").getter(getter(ManualEvidence::textResponse)).setter(setter(Builder::textResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textResponse").build()).build();

    private static final SdkField<String> EVIDENCE_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceFileName").getter(getter(ManualEvidence::evidenceFileName))
            .setter(setter(Builder::evidenceFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCE_PATH_FIELD,
            TEXT_RESPONSE_FIELD, EVIDENCE_FILE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3ResourcePath;

    private final String textResponse;

    private final String evidenceFileName;

    private ManualEvidence(BuilderImpl builder) {
        this.s3ResourcePath = builder.s3ResourcePath;
        this.textResponse = builder.textResponse;
        this.evidenceFileName = builder.evidenceFileName;
    }

    /**
     * <p>
     * The S3 URL of the object that's imported as manual evidence.
     * </p>
     * 
     * @return The S3 URL of the object that's imported as manual evidence.
     */
    public final String s3ResourcePath() {
        return s3ResourcePath;
    }

    /**
     * <p>
     * The plain text response that's entered and saved as manual evidence.
     * </p>
     * 
     * @return The plain text response that's entered and saved as manual evidence.
     */
    public final String textResponse() {
        return textResponse;
    }

    /**
     * <p>
     * The name of the file that's uploaded as manual evidence. This name is populated using the
     * <code>evidenceFileName</code> value from the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFileUploadUrl.html">
     * <code>GetEvidenceFileUploadUrl</code> </a> API response.
     * </p>
     * 
     * @return The name of the file that's uploaded as manual evidence. This name is populated using the
     *         <code>evidenceFileName</code> value from the <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFileUploadUrl.html">
     *         <code>GetEvidenceFileUploadUrl</code> </a> API response.
     */
    public final String evidenceFileName() {
        return evidenceFileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ResourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(textResponse());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManualEvidence)) {
            return false;
        }
        ManualEvidence other = (ManualEvidence) obj;
        return Objects.equals(s3ResourcePath(), other.s3ResourcePath()) && Objects.equals(textResponse(), other.textResponse())
                && Objects.equals(evidenceFileName(), other.evidenceFileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManualEvidence").add("S3ResourcePath", s3ResourcePath()).add("TextResponse", textResponse())
                .add("EvidenceFileName", evidenceFileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3ResourcePath":
            return Optional.ofNullable(clazz.cast(s3ResourcePath()));
        case "textResponse":
            return Optional.ofNullable(clazz.cast(textResponse()));
        case "evidenceFileName":
            return Optional.ofNullable(clazz.cast(evidenceFileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManualEvidence, T> g) {
        return obj -> g.apply((ManualEvidence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManualEvidence> {
        /**
         * <p>
         * The S3 URL of the object that's imported as manual evidence.
         * </p>
         * 
         * @param s3ResourcePath
         *        The S3 URL of the object that's imported as manual evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResourcePath(String s3ResourcePath);

        /**
         * <p>
         * The plain text response that's entered and saved as manual evidence.
         * </p>
         * 
         * @param textResponse
         *        The plain text response that's entered and saved as manual evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textResponse(String textResponse);

        /**
         * <p>
         * The name of the file that's uploaded as manual evidence. This name is populated using the
         * <code>evidenceFileName</code> value from the <a
         * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFileUploadUrl.html">
         * <code>GetEvidenceFileUploadUrl</code> </a> API response.
         * </p>
         * 
         * @param evidenceFileName
         *        The name of the file that's uploaded as manual evidence. This name is populated using the
         *        <code>evidenceFileName</code> value from the <a
         *        href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFileUploadUrl.html"
         *        > <code>GetEvidenceFileUploadUrl</code> </a> API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFileName(String evidenceFileName);
    }

    static final class BuilderImpl implements Builder {
        private String s3ResourcePath;

        private String textResponse;

        private String evidenceFileName;

        private BuilderImpl() {
        }

        private BuilderImpl(ManualEvidence model) {
            s3ResourcePath(model.s3ResourcePath);
            textResponse(model.textResponse);
            evidenceFileName(model.evidenceFileName);
        }

        public final String getS3ResourcePath() {
            return s3ResourcePath;
        }

        public final void setS3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
        }

        @Override
        public final Builder s3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
            return this;
        }

        public final String getTextResponse() {
            return textResponse;
        }

        public final void setTextResponse(String textResponse) {
            this.textResponse = textResponse;
        }

        @Override
        public final Builder textResponse(String textResponse) {
            this.textResponse = textResponse;
            return this;
        }

        public final String getEvidenceFileName() {
            return evidenceFileName;
        }

        public final void setEvidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
        }

        @Override
        public final Builder evidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
            return this;
        }

        @Override
        public ManualEvidence build() {
            return new ManualEvidence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
