/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.WorkGroupConfiguration;
import software.amazon.awssdk.services.athena.model.WorkGroupState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkGroup.getter(WorkGroup::name)).setter(WorkGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkGroup.getter(WorkGroup::stateAsString)).setter(WorkGroup.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<WorkGroupConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkGroup.getter(WorkGroup::configuration)).setter(WorkGroup.setter(Builder::configuration)).constructor(WorkGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkGroup.getter(WorkGroup::description)).setter(WorkGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkGroup.getter(WorkGroup::creationTime)).setter(WorkGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String state;
    private final WorkGroupConfiguration configuration;
    private final String description;
    private final Instant creationTime;

    private WorkGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
    }

    public String name() {
        return this.name;
    }

    public WorkGroupState state() {
        return WorkGroupState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public WorkGroupConfiguration configuration() {
        return this.configuration;
    }

    public String description() {
        return this.description;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroup)) {
            return false;
        }
        WorkGroup other = (WorkGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"WorkGroup").add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("Configuration", (Object)this.configuration()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroup, T> g) {
        return obj -> g.apply((WorkGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String state;
        private WorkGroupConfiguration configuration;
        private String description;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroup model) {
            this.name(model.name);
            this.state(model.state);
            this.configuration(model.configuration);
            this.description(model.description);
            this.creationTime(model.creationTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final WorkGroupConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(WorkGroupConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(WorkGroupConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public WorkGroup build() {
            return new WorkGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroup> {
        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(WorkGroupState var1);

        public Builder configuration(WorkGroupConfiguration var1);

        default public Builder configuration(Consumer<WorkGroupConfiguration.Builder> configuration) {
            return this.configuration((WorkGroupConfiguration)((WorkGroupConfiguration.Builder)WorkGroupConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder creationTime(Instant var1);
    }
}

