/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroupConfiguration> {
    private static final SdkField<ResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::resultConfiguration)).setter(WorkGroupConfiguration.setter(Builder::resultConfiguration)).constructor(ResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build()}).build();
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::enforceWorkGroupConfiguration)).setter(WorkGroupConfiguration.setter(Builder::enforceWorkGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration").build()}).build();
    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::publishCloudWatchMetricsEnabled)).setter(WorkGroupConfiguration.setter(Builder::publishCloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::bytesScannedCutoffPerQuery)).setter(WorkGroupConfiguration.setter(Builder::bytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_CONFIGURATION_FIELD, ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD, BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResultConfiguration resultConfiguration;
    private final Boolean enforceWorkGroupConfiguration;
    private final Boolean publishCloudWatchMetricsEnabled;
    private final Long bytesScannedCutoffPerQuery;

    private WorkGroupConfiguration(BuilderImpl builder) {
        this.resultConfiguration = builder.resultConfiguration;
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
    }

    public ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public Boolean enforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    public Boolean publishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    public Long bytesScannedCutoffPerQuery() {
        return this.bytesScannedCutoffPerQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScannedCutoffPerQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfiguration)) {
            return false;
        }
        WorkGroupConfiguration other = (WorkGroupConfiguration)obj;
        return Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration()) && Objects.equals(this.publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled()) && Objects.equals(this.bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery());
    }

    public String toString() {
        return ToString.builder((String)"WorkGroupConfiguration").add("ResultConfiguration", (Object)this.resultConfiguration()).add("EnforceWorkGroupConfiguration", (Object)this.enforceWorkGroupConfiguration()).add("PublishCloudWatchMetricsEnabled", (Object)this.publishCloudWatchMetricsEnabled()).add("BytesScannedCutoffPerQuery", (Object)this.bytesScannedCutoffPerQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "EnforceWorkGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enforceWorkGroupConfiguration()));
            }
            case "PublishCloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.publishCloudWatchMetricsEnabled()));
            }
            case "BytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.bytesScannedCutoffPerQuery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfiguration, T> g) {
        return obj -> g.apply((WorkGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResultConfiguration resultConfiguration;
        private Boolean enforceWorkGroupConfiguration;
        private Boolean publishCloudWatchMetricsEnabled;
        private Long bytesScannedCutoffPerQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfiguration model) {
            this.resultConfiguration(model.resultConfiguration);
            this.enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            this.publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            this.bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return this.enforceWorkGroupConfiguration;
        }

        @Override
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return this.publishCloudWatchMetricsEnabled;
        }

        @Override
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return this.bytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        public WorkGroupConfiguration build() {
            return new WorkGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroupConfiguration> {
        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder enforceWorkGroupConfiguration(Boolean var1);

        public Builder publishCloudWatchMetricsEnabled(Boolean var1);

        public Builder bytesScannedCutoffPerQuery(Long var1);
    }
}

