/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecutionStatistics> {
    private static final SdkField<Long> ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::engineExecutionTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::engineExecutionTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineExecutionTimeInMillis").build()}).build();
    private static final SdkField<Long> DATA_SCANNED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::dataScannedInBytes)).setter(QueryExecutionStatistics.setter(Builder::dataScannedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD, DATA_SCANNED_IN_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long engineExecutionTimeInMillis;
    private final Long dataScannedInBytes;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
    }

    public Long engineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public Long dataScannedInBytes() {
        return this.dataScannedInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataScannedInBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics)obj;
        return Objects.equals(this.engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis()) && Objects.equals(this.dataScannedInBytes(), other.dataScannedInBytes());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecutionStatistics").add("EngineExecutionTimeInMillis", (Object)this.engineExecutionTimeInMillis()).add("DataScannedInBytes", (Object)this.dataScannedInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineExecutionTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.engineExecutionTimeInMillis()));
            }
            case "DataScannedInBytes": {
                return Optional.ofNullable(clazz.cast(this.dataScannedInBytes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatistics, T> g) {
        return obj -> g.apply((QueryExecutionStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long engineExecutionTimeInMillis;
        private Long dataScannedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            this.engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            this.dataScannedInBytes(model.dataScannedInBytes);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return this.engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        public final Long getDataScannedInBytes() {
            return this.dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecutionStatistics> {
        public Builder engineExecutionTimeInMillis(Long var1);

        public Builder dataScannedInBytes(Long var1);
    }
}

