/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.athena.model.LogTypesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLoggingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::enabled)).setter(CloudWatchLoggingConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logGroup)).setter(CloudWatchLoggingConfiguration.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStreamNamePrefix").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logStreamNamePrefix)).setter(CloudWatchLoggingConfiguration.setter(Builder::logStreamNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamNamePrefix").build()}).build();
    private static final SdkField<Map<String, List<String>>> LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogTypes").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logTypes)).setter(CloudWatchLoggingConfiguration.setter(Builder::logTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LOG_GROUP_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, LOG_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchLoggingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String logGroup;
    private final String logStreamNamePrefix;
    private final Map<String, List<String>> logTypes;

    private CloudWatchLoggingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroup = builder.logGroup;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.logTypes = builder.logTypes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String logGroup() {
        return this.logGroup;
    }

    public final String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public final boolean hasLogTypes() {
        return this.logTypes != null && !(this.logTypes instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> logTypes() {
        return this.logTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypes() ? this.logTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingConfiguration)) {
            return false;
        }
        CloudWatchLoggingConfiguration other = (CloudWatchLoggingConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix()) && this.hasLogTypes() == other.hasLogTypes() && Objects.equals(this.logTypes(), other.logTypes());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLoggingConfiguration").add("Enabled", (Object)this.enabled()).add("LogGroup", (Object)this.logGroup()).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).add("LogTypes", this.hasLogTypes() ? this.logTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
            case "LogStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
            case "LogTypes": {
                return Optional.ofNullable(clazz.cast(this.logTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("LogGroup", LOG_GROUP_FIELD);
        map.put("LogStreamNamePrefix", LOG_STREAM_NAME_PREFIX_FIELD);
        map.put("LogTypes", LOG_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingConfiguration, T> g) {
        return obj -> g.apply((CloudWatchLoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String logGroup;
        private String logStreamNamePrefix;
        private Map<String, List<String>> logTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingConfiguration model) {
            this.enabled(model.enabled);
            this.logGroup(model.logGroup);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
            this.logTypes(model.logTypes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getLogTypes() {
            if (this.logTypes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.logTypes;
        }

        public final void setLogTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypesMapCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypesMapCopier.copy(logTypes);
            return this;
        }

        public CloudWatchLoggingConfiguration build() {
            return new CloudWatchLoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLoggingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder logGroup(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder logTypes(Map<String, ? extends Collection<String>> var1);
    }
}

