/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataCatalogRequest extends AthenaRequest implements
        ToCopyableBuilder<UpdateDataCatalogRequest.Builder, UpdateDataCatalogRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDataCatalogRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateDataCatalogRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDataCatalogRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateDataCatalogRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            DESCRIPTION_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String type;

    private final String description;

    private final Map<String, String> parameters;

    private UpdateDataCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services account and
     * can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length
     * constraint of 256 is reserved for use by Athena.
     * </p>
     * 
     * @return The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services
     *         account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The
     *         remainder of the length constraint of 256 is reserved for use by Athena.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
     * <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
     *         <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
     * @see DataCatalogType
     */
    public final DataCatalogType type() {
        return DataCatalogType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
     * <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataCatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
     *         <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
     * @see DataCatalogType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * New or modified text that describes the data catalog.
     * </p>
     * 
     * @return New or modified text that describes the data catalog.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose values
     * depend on the catalog type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code>
     * parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported
     * version.
     * </p>
     * <p>
     * <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not
     * both.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have one Lambda function that processes metadata and another for reading the actual data, use the
     * following syntax. Both parameters are required.
     * </p>
     * <p>
     * <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have a composite Lambda function that processes both metadata and data, use the following syntax to
     * specify your Lambda function.
     * </p>
     * <p>
     * <code>function=<i>lambda_arn</i> </code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose
     *         values depend on the catalog type. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code>
     *         parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently
     *         supported version.
     *         </p>
     *         <p>
     *         <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but
     *         not both.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have one Lambda function that processes metadata and another for reading the actual data, use the
     *         following syntax. Both parameters are required.
     *         </p>
     *         <p>
     *         <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have a composite Lambda function that processes both metadata and data, use the following syntax
     *         to specify your Lambda function.
     *         </p>
     *         <p>
     *         <code>function=<i>lambda_arn</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataCatalogRequest)) {
            return false;
        }
        UpdateDataCatalogRequest other = (UpdateDataCatalogRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataCatalogRequest").add("Name", name()).add("Type", typeAsString())
                .add("Description", description()).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataCatalogRequest, T> g) {
        return obj -> g.apply((UpdateDataCatalogRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataCatalogRequest> {
        /**
         * <p>
         * The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services account
         * and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the
         * length constraint of 256 is reserved for use by Athena.
         * </p>
         * 
         * @param name
         *        The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services
         *        account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The
         *        remainder of the length constraint of 256 is reserved for use by Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
         * <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
         * </p>
         * 
         * @param type
         *        Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
         *        <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
         * @see DataCatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCatalogType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
         * <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
         * </p>
         * 
         * @param type
         *        Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog,
         *        <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.
         * @see DataCatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataCatalogType
         */
        Builder type(DataCatalogType type);

        /**
         * <p>
         * New or modified text that describes the data catalog.
         * </p>
         * 
         * @param description
         *        New or modified text that describes the data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose
         * values depend on the catalog type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code>
         * parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently
         * supported version.
         * </p>
         * <p>
         * <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not
         * both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have one Lambda function that processes metadata and another for reading the actual data, use the
         * following syntax. Both parameters are required.
         * </p>
         * <p>
         * <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have a composite Lambda function that processes both metadata and data, use the following syntax to
         * specify your Lambda function.
         * </p>
         * <p>
         * <code>function=<i>lambda_arn</i> </code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param parameters
         *        Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping
         *        whose values depend on the catalog type. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>HIVE</code> data catalog type, use the following syntax. The
         *        <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is
         *        optional and defaults to the currently supported version.
         *        </p>
         *        <p>
         *        <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters,
         *        but not both.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have one Lambda function that processes metadata and another for reading the actual data, use
         *        the following syntax. Both parameters are required.
         *        </p>
         *        <p>
         *        <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have a composite Lambda function that processes both metadata and data, use the following
         *        syntax to specify your Lambda function.
         *        </p>
         *        <p>
         *        <code>function=<i>lambda_arn</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String name;

        private String type;

        private String description;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataCatalogRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            description(model.description);
            parameters(model.parameters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataCatalogType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataCatalogRequest build() {
            return new UpdateDataCatalogRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
