/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether previous query results are reused, and if so, their maximum age.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultReuseByAgeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultReuseByAgeConfiguration.Builder, ResultReuseByAgeConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(ResultReuseByAgeConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> MAX_AGE_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAgeInMinutes").getter(getter(ResultReuseByAgeConfiguration::maxAgeInMinutes))
            .setter(setter(Builder::maxAgeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MAX_AGE_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer maxAgeInMinutes;

    private ResultReuseByAgeConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxAgeInMinutes = builder.maxAgeInMinutes;
    }

    /**
     * <p>
     * True if previous query results can be reused when the query is run; otherwise, false. The default is false.
     * </p>
     * 
     * @return True if previous query results can be reused when the query is run; otherwise, false. The default is
     *         false.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse. The
     * default is 60.
     * </p>
     * 
     * @return Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse.
     *         The default is 60.
     */
    public final Integer maxAgeInMinutes() {
        return maxAgeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxAgeInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultReuseByAgeConfiguration)) {
            return false;
        }
        ResultReuseByAgeConfiguration other = (ResultReuseByAgeConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(maxAgeInMinutes(), other.maxAgeInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultReuseByAgeConfiguration").add("Enabled", enabled())
                .add("MaxAgeInMinutes", maxAgeInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MaxAgeInMinutes":
            return Optional.ofNullable(clazz.cast(maxAgeInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("MaxAgeInMinutes", MAX_AGE_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultReuseByAgeConfiguration, T> g) {
        return obj -> g.apply((ResultReuseByAgeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultReuseByAgeConfiguration> {
        /**
         * <p>
         * True if previous query results can be reused when the query is run; otherwise, false. The default is false.
         * </p>
         * 
         * @param enabled
         *        True if previous query results can be reused when the query is run; otherwise, false. The default is
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse. The
         * default is 60.
         * </p>
         * 
         * @param maxAgeInMinutes
         *        Specifies, in minutes, the maximum age of a previous query result that Athena should consider for
         *        reuse. The default is 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAgeInMinutes(Integer maxAgeInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer maxAgeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultReuseByAgeConfiguration model) {
            enabled(model.enabled);
            maxAgeInMinutes(model.maxAgeInMinutes);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxAgeInMinutes() {
            return maxAgeInMinutes;
        }

        public final void setMaxAgeInMinutes(Integer maxAgeInMinutes) {
            this.maxAgeInMinutes = maxAgeInMinutes;
        }

        @Override
        public final Builder maxAgeInMinutes(Integer maxAgeInMinutes) {
            this.maxAgeInMinutes = maxAgeInMinutes;
            return this;
        }

        @Override
        public ResultReuseByAgeConfiguration build() {
            return new ResultReuseByAgeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
