/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for storing results in Athena owned storage, which includes whether this feature is enabled;
 * whether encryption configuration, if any, is used for encrypting query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedQueryResultsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedQueryResultsConfiguration.Builder, ManagedQueryResultsConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(ManagedQueryResultsConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<ManagedQueryResultsEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ManagedQueryResultsEncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(ManagedQueryResultsConfiguration::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(ManagedQueryResultsEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final ManagedQueryResultsEncryptionConfiguration encryptionConfiguration;

    private ManagedQueryResultsConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * If set to true, allows you to store query results in Athena owned storage. If set to false, workgroup member
     * stores query results in location specified under <code>ResultConfiguration$OutputLocation</code>. The default is
     * false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code> parameter when you set this
     * field to true.
     * </p>
     * 
     * @return If set to true, allows you to store query results in Athena owned storage. If set to false, workgroup
     *         member stores query results in location specified under <code>ResultConfiguration$OutputLocation</code>.
     *         The default is false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code>
     *         parameter when you set this field to true.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption option
     * (for example, SSE_KMS or CSE_KMS) and key information.
     * </p>
     * 
     * @return If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption
     *         option (for example, SSE_KMS or CSE_KMS) and key information.
     */
    public final ManagedQueryResultsEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedQueryResultsConfiguration)) {
            return false;
        }
        ManagedQueryResultsConfiguration other = (ManagedQueryResultsConfiguration) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedQueryResultsConfiguration").add("Enabled", enabled())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedQueryResultsConfiguration, T> g) {
        return obj -> g.apply((ManagedQueryResultsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedQueryResultsConfiguration> {
        /**
         * <p>
         * If set to true, allows you to store query results in Athena owned storage. If set to false, workgroup member
         * stores query results in location specified under <code>ResultConfiguration$OutputLocation</code>. The default
         * is false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code> parameter when you set
         * this field to true.
         * </p>
         * 
         * @param enabled
         *        If set to true, allows you to store query results in Athena owned storage. If set to false, workgroup
         *        member stores query results in location specified under
         *        <code>ResultConfiguration$OutputLocation</code>. The default is false. A workgroup cannot have the
         *        <code>ResultConfiguration$OutputLocation</code> parameter when you set this field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption
         * option (for example, SSE_KMS or CSE_KMS) and key information.
         * </p>
         * 
         * @param encryptionConfiguration
         *        If you encrypt query and calculation results in Athena owned storage, this field indicates the
         *        encryption option (for example, SSE_KMS or CSE_KMS) and key information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(ManagedQueryResultsEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption
         * option (for example, SSE_KMS or CSE_KMS) and key information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedQueryResultsEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ManagedQueryResultsEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedQueryResultsEncryptionConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionConfiguration(ManagedQueryResultsEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link ManagedQueryResultsEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(ManagedQueryResultsEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(
                Consumer<ManagedQueryResultsEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(ManagedQueryResultsEncryptionConfiguration.builder()
                    .applyMutation(encryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private ManagedQueryResultsEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedQueryResultsConfiguration model) {
            enabled(model.enabled);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ManagedQueryResultsEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(
                ManagedQueryResultsEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(ManagedQueryResultsEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public ManagedQueryResultsConfiguration build() {
            return new ManagedQueryResultsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
