/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether the workgroup is IAM Identity Center supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityCenterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityCenterConfiguration.Builder, IdentityCenterConfiguration> {
    private static final SdkField<Boolean> ENABLE_IDENTITY_CENTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIdentityCenter").getter(getter(IdentityCenterConfiguration::enableIdentityCenter))
            .setter(setter(Builder::enableIdentityCenter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIdentityCenter").build())
            .build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterInstanceArn").getter(getter(IdentityCenterConfiguration::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_IDENTITY_CENTER_FIELD,
            IDENTITY_CENTER_INSTANCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableIdentityCenter;

    private final String identityCenterInstanceArn;

    private IdentityCenterConfiguration(BuilderImpl builder) {
        this.enableIdentityCenter = builder.enableIdentityCenter;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
    }

    /**
     * <p>
     * Specifies whether the workgroup is IAM Identity Center supported.
     * </p>
     * 
     * @return Specifies whether the workgroup is IAM Identity Center supported.
     */
    public final Boolean enableIdentityCenter() {
        return enableIdentityCenter;
    }

    /**
     * <p>
     * The IAM Identity Center instance ARN that the workgroup associates to.
     * </p>
     * 
     * @return The IAM Identity Center instance ARN that the workgroup associates to.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableIdentityCenter());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterConfiguration)) {
            return false;
        }
        IdentityCenterConfiguration other = (IdentityCenterConfiguration) obj;
        return Objects.equals(enableIdentityCenter(), other.enableIdentityCenter())
                && Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityCenterConfiguration").add("EnableIdentityCenter", enableIdentityCenter())
                .add("IdentityCenterInstanceArn", identityCenterInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableIdentityCenter":
            return Optional.ofNullable(clazz.cast(enableIdentityCenter()));
        case "IdentityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableIdentityCenter", ENABLE_IDENTITY_CENTER_FIELD);
        map.put("IdentityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterConfiguration, T> g) {
        return obj -> g.apply((IdentityCenterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityCenterConfiguration> {
        /**
         * <p>
         * Specifies whether the workgroup is IAM Identity Center supported.
         * </p>
         * 
         * @param enableIdentityCenter
         *        Specifies whether the workgroup is IAM Identity Center supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIdentityCenter(Boolean enableIdentityCenter);

        /**
         * <p>
         * The IAM Identity Center instance ARN that the workgroup associates to.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The IAM Identity Center instance ARN that the workgroup associates to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableIdentityCenter;

        private String identityCenterInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterConfiguration model) {
            enableIdentityCenter(model.enableIdentityCenter);
            identityCenterInstanceArn(model.identityCenterInstanceArn);
        }

        public final Boolean getEnableIdentityCenter() {
            return enableIdentityCenter;
        }

        public final void setEnableIdentityCenter(Boolean enableIdentityCenter) {
            this.enableIdentityCenter = enableIdentityCenter;
        }

        @Override
        public final Builder enableIdentityCenter(Boolean enableIdentityCenter) {
            this.enableIdentityCenter = enableIdentityCenter;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        @Override
        public IdentityCenterConfiguration build() {
            return new IdentityCenterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
