/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCalculationExecutionResponse extends AthenaResponse implements
        ToCopyableBuilder<GetCalculationExecutionResponse.Builder, GetCalculationExecutionResponse> {
    private static final SdkField<String> CALCULATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculationExecutionId").getter(getter(GetCalculationExecutionResponse::calculationExecutionId))
            .setter(setter(Builder::calculationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationExecutionId").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(GetCalculationExecutionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetCalculationExecutionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkingDirectory").getter(getter(GetCalculationExecutionResponse::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()).build();

    private static final SdkField<CalculationStatus> STATUS_FIELD = SdkField
            .<CalculationStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(GetCalculationExecutionResponse::status)).setter(setter(Builder::status))
            .constructor(CalculationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CalculationStatistics> STATISTICS_FIELD = SdkField
            .<CalculationStatistics> builder(MarshallingType.SDK_POJO).memberName("Statistics")
            .getter(getter(GetCalculationExecutionResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(CalculationStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final SdkField<CalculationResult> RESULT_FIELD = SdkField
            .<CalculationResult> builder(MarshallingType.SDK_POJO).memberName("Result")
            .getter(getter(GetCalculationExecutionResponse::result)).setter(setter(Builder::result))
            .constructor(CalculationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CALCULATION_EXECUTION_ID_FIELD, SESSION_ID_FIELD, DESCRIPTION_FIELD, WORKING_DIRECTORY_FIELD, STATUS_FIELD,
            STATISTICS_FIELD, RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String calculationExecutionId;

    private final String sessionId;

    private final String description;

    private final String workingDirectory;

    private final CalculationStatus status;

    private final CalculationStatistics statistics;

    private final CalculationResult result;

    private GetCalculationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.calculationExecutionId = builder.calculationExecutionId;
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.workingDirectory = builder.workingDirectory;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.result = builder.result;
    }

    /**
     * <p>
     * The calculation execution UUID.
     * </p>
     * 
     * @return The calculation execution UUID.
     */
    public final String calculationExecutionId() {
        return calculationExecutionId;
    }

    /**
     * <p>
     * The session ID that the calculation ran in.
     * </p>
     * 
     * @return The session ID that the calculation ran in.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The description of the calculation execution.
     * </p>
     * 
     * @return The description of the calculation execution.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon S3 location in which calculation results are stored.
     * </p>
     * 
     * @return The Amazon S3 location in which calculation results are stored.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * Contains information about the status of the calculation.
     * </p>
     * 
     * @return Contains information about the status of the calculation.
     */
    public final CalculationStatus status() {
        return status;
    }

    /**
     * <p>
     * Contains information about the data processing unit (DPU) execution time and progress. This field is populated
     * only when statistics are available.
     * </p>
     * 
     * @return Contains information about the data processing unit (DPU) execution time and progress. This field is
     *         populated only when statistics are available.
     */
    public final CalculationStatistics statistics() {
        return statistics;
    }

    /**
     * <p>
     * Contains result information. This field is populated only if the calculation is completed.
     * </p>
     * 
     * @return Contains result information. This field is populated only if the calculation is completed.
     */
    public final CalculationResult result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalculationExecutionResponse)) {
            return false;
        }
        GetCalculationExecutionResponse other = (GetCalculationExecutionResponse) obj;
        return Objects.equals(calculationExecutionId(), other.calculationExecutionId())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(description(), other.description())
                && Objects.equals(workingDirectory(), other.workingDirectory()) && Objects.equals(status(), other.status())
                && Objects.equals(statistics(), other.statistics()) && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCalculationExecutionResponse").add("CalculationExecutionId", calculationExecutionId())
                .add("SessionId", sessionId()).add("Description", description()).add("WorkingDirectory", workingDirectory())
                .add("Status", status()).add("Statistics", statistics()).add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculationExecutionId":
            return Optional.ofNullable(clazz.cast(calculationExecutionId()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "WorkingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CalculationExecutionId", CALCULATION_EXECUTION_ID_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        map.put("Result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCalculationExecutionResponse, T> g) {
        return obj -> g.apply((GetCalculationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCalculationExecutionResponse> {
        /**
         * <p>
         * The calculation execution UUID.
         * </p>
         * 
         * @param calculationExecutionId
         *        The calculation execution UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculationExecutionId(String calculationExecutionId);

        /**
         * <p>
         * The session ID that the calculation ran in.
         * </p>
         * 
         * @param sessionId
         *        The session ID that the calculation ran in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The description of the calculation execution.
         * </p>
         * 
         * @param description
         *        The description of the calculation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon S3 location in which calculation results are stored.
         * </p>
         * 
         * @param workingDirectory
         *        The Amazon S3 location in which calculation results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * Contains information about the status of the calculation.
         * </p>
         * 
         * @param status
         *        Contains information about the status of the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CalculationStatus status);

        /**
         * <p>
         * Contains information about the status of the calculation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationStatus.Builder} avoiding the
         * need to create one manually via {@link CalculationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(CalculationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CalculationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CalculationStatus)
         */
        default Builder status(Consumer<CalculationStatus.Builder> status) {
            return status(CalculationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Contains information about the data processing unit (DPU) execution time and progress. This field is
         * populated only when statistics are available.
         * </p>
         * 
         * @param statistics
         *        Contains information about the data processing unit (DPU) execution time and progress. This field is
         *        populated only when statistics are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(CalculationStatistics statistics);

        /**
         * <p>
         * Contains information about the data processing unit (DPU) execution time and progress. This field is
         * populated only when statistics are available.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationStatistics.Builder} avoiding
         * the need to create one manually via {@link CalculationStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(CalculationStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link CalculationStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(CalculationStatistics)
         */
        default Builder statistics(Consumer<CalculationStatistics.Builder> statistics) {
            return statistics(CalculationStatistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * Contains result information. This field is populated only if the calculation is completed.
         * </p>
         * 
         * @param result
         *        Contains result information. This field is populated only if the calculation is completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(CalculationResult result);

        /**
         * <p>
         * Contains result information. This field is populated only if the calculation is completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationResult.Builder} avoiding the
         * need to create one manually via {@link CalculationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationResult.Builder#build()} is called immediately and its
         * result is passed to {@link #result(CalculationResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link CalculationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(CalculationResult)
         */
        default Builder result(Consumer<CalculationResult.Builder> result) {
            return result(CalculationResult.builder().applyMutation(result).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String calculationExecutionId;

        private String sessionId;

        private String description;

        private String workingDirectory;

        private CalculationStatus status;

        private CalculationStatistics statistics;

        private CalculationResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalculationExecutionResponse model) {
            super(model);
            calculationExecutionId(model.calculationExecutionId);
            sessionId(model.sessionId);
            description(model.description);
            workingDirectory(model.workingDirectory);
            status(model.status);
            statistics(model.statistics);
            result(model.result);
        }

        public final String getCalculationExecutionId() {
            return calculationExecutionId;
        }

        public final void setCalculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
        }

        @Override
        public final Builder calculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final CalculationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CalculationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CalculationStatus status) {
            this.status = status;
            return this;
        }

        public final CalculationStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(CalculationStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(CalculationStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final CalculationResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(CalculationResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(CalculationResult result) {
            this.result = result;
            return this;
        }

        @Override
        public GetCalculationExecutionResponse build() {
            return new GetCalculationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
