/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about an executor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutorsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutorsSummary.Builder, ExecutorsSummary> {
    private static final SdkField<String> EXECUTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutorId").getter(getter(ExecutorsSummary::executorId)).setter(setter(Builder::executorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorId").build()).build();

    private static final SdkField<String> EXECUTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutorType").getter(getter(ExecutorsSummary::executorTypeAsString))
            .setter(setter(Builder::executorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorType").build()).build();

    private static final SdkField<Long> START_DATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartDateTime").getter(getter(ExecutorsSummary::startDateTime)).setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<Long> TERMINATION_DATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TerminationDateTime").getter(getter(ExecutorsSummary::terminationDateTime))
            .setter(setter(Builder::terminationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationDateTime").build())
            .build();

    private static final SdkField<String> EXECUTOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutorState").getter(getter(ExecutorsSummary::executorStateAsString))
            .setter(setter(Builder::executorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorState").build()).build();

    private static final SdkField<Long> EXECUTOR_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ExecutorSize").getter(getter(ExecutorsSummary::executorSize)).setter(setter(Builder::executorSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTOR_ID_FIELD,
            EXECUTOR_TYPE_FIELD, START_DATE_TIME_FIELD, TERMINATION_DATE_TIME_FIELD, EXECUTOR_STATE_FIELD, EXECUTOR_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executorId;

    private final String executorType;

    private final Long startDateTime;

    private final Long terminationDateTime;

    private final String executorState;

    private final Long executorSize;

    private ExecutorsSummary(BuilderImpl builder) {
        this.executorId = builder.executorId;
        this.executorType = builder.executorType;
        this.startDateTime = builder.startDateTime;
        this.terminationDateTime = builder.terminationDateTime;
        this.executorState = builder.executorState;
        this.executorSize = builder.executorSize;
    }

    /**
     * <p>
     * The UUID of the executor.
     * </p>
     * 
     * @return The UUID of the executor.
     */
    public final String executorId() {
        return executorId;
    }

    /**
     * <p>
     * The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
     * <code>WORKER</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executorType} will
     * return {@link ExecutorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executorTypeAsString}.
     * </p>
     * 
     * @return The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
     *         <code>WORKER</code>).
     * @see ExecutorType
     */
    public final ExecutorType executorType() {
        return ExecutorType.fromValue(executorType);
    }

    /**
     * <p>
     * The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
     * <code>WORKER</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executorType} will
     * return {@link ExecutorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executorTypeAsString}.
     * </p>
     * 
     * @return The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
     *         <code>WORKER</code>).
     * @see ExecutorType
     */
    public final String executorTypeAsString() {
        return executorType;
    }

    /**
     * <p>
     * The date and time that the executor started.
     * </p>
     * 
     * @return The date and time that the executor started.
     */
    public final Long startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The date and time that the executor was terminated.
     * </p>
     * 
     * @return The date and time that the executor was terminated.
     */
    public final Long terminationDateTime() {
        return terminationDateTime;
    }

    /**
     * <p>
     * The processing state of the executor. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The executor is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The executor has been started.
     * </p>
     * <p>
     * <code>REGISTERED</code> - The executor has been registered.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The executor is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The executor is no longer running.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executorState}
     * will return {@link ExecutorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executorStateAsString}.
     * </p>
     * 
     * @return The processing state of the executor. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The executor is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The executor has been started.
     *         </p>
     *         <p>
     *         <code>REGISTERED</code> - The executor has been registered.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The executor is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The executor is no longer running.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * @see ExecutorState
     */
    public final ExecutorState executorState() {
        return ExecutorState.fromValue(executorState);
    }

    /**
     * <p>
     * The processing state of the executor. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The executor is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The executor has been started.
     * </p>
     * <p>
     * <code>REGISTERED</code> - The executor has been registered.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The executor is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The executor is no longer running.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executorState}
     * will return {@link ExecutorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executorStateAsString}.
     * </p>
     * 
     * @return The processing state of the executor. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The executor is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The executor has been started.
     *         </p>
     *         <p>
     *         <code>REGISTERED</code> - The executor has been registered.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The executor is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The executor is no longer running.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * @see ExecutorState
     */
    public final String executorStateAsString() {
        return executorState;
    }

    /**
     * <p>
     * The smallest unit of compute that a session can request from Athena. Size is measured in data processing unit
     * (DPU) values, a relative measure of processing power.
     * </p>
     * 
     * @return The smallest unit of compute that a session can request from Athena. Size is measured in data processing
     *         unit (DPU) values, a relative measure of processing power.
     */
    public final Long executorSize() {
        return executorSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executorId());
        hashCode = 31 * hashCode + Objects.hashCode(executorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(terminationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(executorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executorSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutorsSummary)) {
            return false;
        }
        ExecutorsSummary other = (ExecutorsSummary) obj;
        return Objects.equals(executorId(), other.executorId())
                && Objects.equals(executorTypeAsString(), other.executorTypeAsString())
                && Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(terminationDateTime(), other.terminationDateTime())
                && Objects.equals(executorStateAsString(), other.executorStateAsString())
                && Objects.equals(executorSize(), other.executorSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutorsSummary").add("ExecutorId", executorId()).add("ExecutorType", executorTypeAsString())
                .add("StartDateTime", startDateTime()).add("TerminationDateTime", terminationDateTime())
                .add("ExecutorState", executorStateAsString()).add("ExecutorSize", executorSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutorId":
            return Optional.ofNullable(clazz.cast(executorId()));
        case "ExecutorType":
            return Optional.ofNullable(clazz.cast(executorTypeAsString()));
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "TerminationDateTime":
            return Optional.ofNullable(clazz.cast(terminationDateTime()));
        case "ExecutorState":
            return Optional.ofNullable(clazz.cast(executorStateAsString()));
        case "ExecutorSize":
            return Optional.ofNullable(clazz.cast(executorSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutorId", EXECUTOR_ID_FIELD);
        map.put("ExecutorType", EXECUTOR_TYPE_FIELD);
        map.put("StartDateTime", START_DATE_TIME_FIELD);
        map.put("TerminationDateTime", TERMINATION_DATE_TIME_FIELD);
        map.put("ExecutorState", EXECUTOR_STATE_FIELD);
        map.put("ExecutorSize", EXECUTOR_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutorsSummary, T> g) {
        return obj -> g.apply((ExecutorsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutorsSummary> {
        /**
         * <p>
         * The UUID of the executor.
         * </p>
         * 
         * @param executorId
         *        The UUID of the executor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executorId(String executorId);

        /**
         * <p>
         * The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
         * <code>WORKER</code>).
         * </p>
         * 
         * @param executorType
         *        The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
         *        <code>WORKER</code>).
         * @see ExecutorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorType
         */
        Builder executorType(String executorType);

        /**
         * <p>
         * The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
         * <code>WORKER</code>).
         * </p>
         * 
         * @param executorType
         *        The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or
         *        <code>WORKER</code>).
         * @see ExecutorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorType
         */
        Builder executorType(ExecutorType executorType);

        /**
         * <p>
         * The date and time that the executor started.
         * </p>
         * 
         * @param startDateTime
         *        The date and time that the executor started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Long startDateTime);

        /**
         * <p>
         * The date and time that the executor was terminated.
         * </p>
         * 
         * @param terminationDateTime
         *        The date and time that the executor was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationDateTime(Long terminationDateTime);

        /**
         * <p>
         * The processing state of the executor. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The executor is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The executor has been started.
         * </p>
         * <p>
         * <code>REGISTERED</code> - The executor has been registered.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The executor is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The executor is no longer running.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * </p>
         * 
         * @param executorState
         *        The processing state of the executor. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The executor is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The executor has been started.
         *        </p>
         *        <p>
         *        <code>REGISTERED</code> - The executor has been registered.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The executor is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The executor is no longer running.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * @see ExecutorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorState
         */
        Builder executorState(String executorState);

        /**
         * <p>
         * The processing state of the executor. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The executor is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The executor has been started.
         * </p>
         * <p>
         * <code>REGISTERED</code> - The executor has been registered.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The executor is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The executor is no longer running.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * </p>
         * 
         * @param executorState
         *        The processing state of the executor. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The executor is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The executor has been started.
         *        </p>
         *        <p>
         *        <code>REGISTERED</code> - The executor has been registered.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The executor is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The executor is no longer running.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * @see ExecutorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorState
         */
        Builder executorState(ExecutorState executorState);

        /**
         * <p>
         * The smallest unit of compute that a session can request from Athena. Size is measured in data processing unit
         * (DPU) values, a relative measure of processing power.
         * </p>
         * 
         * @param executorSize
         *        The smallest unit of compute that a session can request from Athena. Size is measured in data
         *        processing unit (DPU) values, a relative measure of processing power.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executorSize(Long executorSize);
    }

    static final class BuilderImpl implements Builder {
        private String executorId;

        private String executorType;

        private Long startDateTime;

        private Long terminationDateTime;

        private String executorState;

        private Long executorSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutorsSummary model) {
            executorId(model.executorId);
            executorType(model.executorType);
            startDateTime(model.startDateTime);
            terminationDateTime(model.terminationDateTime);
            executorState(model.executorState);
            executorSize(model.executorSize);
        }

        public final String getExecutorId() {
            return executorId;
        }

        public final void setExecutorId(String executorId) {
            this.executorId = executorId;
        }

        @Override
        public final Builder executorId(String executorId) {
            this.executorId = executorId;
            return this;
        }

        public final String getExecutorType() {
            return executorType;
        }

        public final void setExecutorType(String executorType) {
            this.executorType = executorType;
        }

        @Override
        public final Builder executorType(String executorType) {
            this.executorType = executorType;
            return this;
        }

        @Override
        public final Builder executorType(ExecutorType executorType) {
            this.executorType(executorType == null ? null : executorType.toString());
            return this;
        }

        public final Long getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Long startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Long startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Long getTerminationDateTime() {
            return terminationDateTime;
        }

        public final void setTerminationDateTime(Long terminationDateTime) {
            this.terminationDateTime = terminationDateTime;
        }

        @Override
        public final Builder terminationDateTime(Long terminationDateTime) {
            this.terminationDateTime = terminationDateTime;
            return this;
        }

        public final String getExecutorState() {
            return executorState;
        }

        public final void setExecutorState(String executorState) {
            this.executorState = executorState;
        }

        @Override
        public final Builder executorState(String executorState) {
            this.executorState = executorState;
            return this;
        }

        @Override
        public final Builder executorState(ExecutorState executorState) {
            this.executorState(executorState == null ? null : executorState.toString());
            return this;
        }

        public final Long getExecutorSize() {
            return executorSize;
        }

        public final void setExecutorSize(Long executorSize) {
            this.executorSize = executorSize;
        }

        @Override
        public final Builder executorSize(Long executorSize) {
            this.executorSize = executorSize;
            return this;
        }

        @Override
        public ExecutorsSummary build() {
            return new ExecutorsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
