/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an application-specific calculation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculationResult.Builder, CalculationResult> {
    private static final SdkField<String> STD_OUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StdOutS3Uri").getter(getter(CalculationResult::stdOutS3Uri)).setter(setter(Builder::stdOutS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StdOutS3Uri").build()).build();

    private static final SdkField<String> STD_ERROR_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StdErrorS3Uri").getter(getter(CalculationResult::stdErrorS3Uri)).setter(setter(Builder::stdErrorS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StdErrorS3Uri").build()).build();

    private static final SdkField<String> RESULT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultS3Uri").getter(getter(CalculationResult::resultS3Uri)).setter(setter(Builder::resultS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultS3Uri").build()).build();

    private static final SdkField<String> RESULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultType").getter(getter(CalculationResult::resultType)).setter(setter(Builder::resultType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STD_OUT_S3_URI_FIELD,
            STD_ERROR_S3_URI_FIELD, RESULT_S3_URI_FIELD, RESULT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stdOutS3Uri;

    private final String stdErrorS3Uri;

    private final String resultS3Uri;

    private final String resultType;

    private CalculationResult(BuilderImpl builder) {
        this.stdOutS3Uri = builder.stdOutS3Uri;
        this.stdErrorS3Uri = builder.stdErrorS3Uri;
        this.resultS3Uri = builder.resultS3Uri;
        this.resultType = builder.resultType;
    }

    /**
     * <p>
     * The Amazon S3 location of the <code>stdout</code> file for the calculation.
     * </p>
     * 
     * @return The Amazon S3 location of the <code>stdout</code> file for the calculation.
     */
    public final String stdOutS3Uri() {
        return stdOutS3Uri;
    }

    /**
     * <p>
     * The Amazon S3 location of the <code>stderr</code> error messages file for the calculation.
     * </p>
     * 
     * @return The Amazon S3 location of the <code>stderr</code> error messages file for the calculation.
     */
    public final String stdErrorS3Uri() {
        return stdErrorS3Uri;
    }

    /**
     * <p>
     * The Amazon S3 location of the folder for the calculation results.
     * </p>
     * 
     * @return The Amazon S3 location of the folder for the calculation results.
     */
    public final String resultS3Uri() {
        return resultS3Uri;
    }

    /**
     * <p>
     * The data format of the calculation result.
     * </p>
     * 
     * @return The data format of the calculation result.
     */
    public final String resultType() {
        return resultType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stdOutS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(stdErrorS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(resultS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(resultType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculationResult)) {
            return false;
        }
        CalculationResult other = (CalculationResult) obj;
        return Objects.equals(stdOutS3Uri(), other.stdOutS3Uri()) && Objects.equals(stdErrorS3Uri(), other.stdErrorS3Uri())
                && Objects.equals(resultS3Uri(), other.resultS3Uri()) && Objects.equals(resultType(), other.resultType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculationResult").add("StdOutS3Uri", stdOutS3Uri()).add("StdErrorS3Uri", stdErrorS3Uri())
                .add("ResultS3Uri", resultS3Uri()).add("ResultType", resultType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StdOutS3Uri":
            return Optional.ofNullable(clazz.cast(stdOutS3Uri()));
        case "StdErrorS3Uri":
            return Optional.ofNullable(clazz.cast(stdErrorS3Uri()));
        case "ResultS3Uri":
            return Optional.ofNullable(clazz.cast(resultS3Uri()));
        case "ResultType":
            return Optional.ofNullable(clazz.cast(resultType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StdOutS3Uri", STD_OUT_S3_URI_FIELD);
        map.put("StdErrorS3Uri", STD_ERROR_S3_URI_FIELD);
        map.put("ResultS3Uri", RESULT_S3_URI_FIELD);
        map.put("ResultType", RESULT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculationResult, T> g) {
        return obj -> g.apply((CalculationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculationResult> {
        /**
         * <p>
         * The Amazon S3 location of the <code>stdout</code> file for the calculation.
         * </p>
         * 
         * @param stdOutS3Uri
         *        The Amazon S3 location of the <code>stdout</code> file for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdOutS3Uri(String stdOutS3Uri);

        /**
         * <p>
         * The Amazon S3 location of the <code>stderr</code> error messages file for the calculation.
         * </p>
         * 
         * @param stdErrorS3Uri
         *        The Amazon S3 location of the <code>stderr</code> error messages file for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdErrorS3Uri(String stdErrorS3Uri);

        /**
         * <p>
         * The Amazon S3 location of the folder for the calculation results.
         * </p>
         * 
         * @param resultS3Uri
         *        The Amazon S3 location of the folder for the calculation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultS3Uri(String resultS3Uri);

        /**
         * <p>
         * The data format of the calculation result.
         * </p>
         * 
         * @param resultType
         *        The data format of the calculation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultType(String resultType);
    }

    static final class BuilderImpl implements Builder {
        private String stdOutS3Uri;

        private String stdErrorS3Uri;

        private String resultS3Uri;

        private String resultType;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculationResult model) {
            stdOutS3Uri(model.stdOutS3Uri);
            stdErrorS3Uri(model.stdErrorS3Uri);
            resultS3Uri(model.resultS3Uri);
            resultType(model.resultType);
        }

        public final String getStdOutS3Uri() {
            return stdOutS3Uri;
        }

        public final void setStdOutS3Uri(String stdOutS3Uri) {
            this.stdOutS3Uri = stdOutS3Uri;
        }

        @Override
        public final Builder stdOutS3Uri(String stdOutS3Uri) {
            this.stdOutS3Uri = stdOutS3Uri;
            return this;
        }

        public final String getStdErrorS3Uri() {
            return stdErrorS3Uri;
        }

        public final void setStdErrorS3Uri(String stdErrorS3Uri) {
            this.stdErrorS3Uri = stdErrorS3Uri;
        }

        @Override
        public final Builder stdErrorS3Uri(String stdErrorS3Uri) {
            this.stdErrorS3Uri = stdErrorS3Uri;
            return this;
        }

        public final String getResultS3Uri() {
            return resultS3Uri;
        }

        public final void setResultS3Uri(String resultS3Uri) {
            this.resultS3Uri = resultS3Uri;
        }

        @Override
        public final Builder resultS3Uri(String resultS3Uri) {
            this.resultS3Uri = resultS3Uri;
            return this;
        }

        public final String getResultType() {
            return resultType;
        }

        public final void setResultType(String resultType) {
            this.resultType = resultType;
        }

        @Override
        public final Builder resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        @Override
        public CalculationResult build() {
            return new CalculationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
