/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPreparedStatementRequest extends AthenaRequest implements
        ToCopyableBuilder<BatchGetPreparedStatementRequest.Builder, BatchGetPreparedStatementRequest> {
    private static final SdkField<List<String>> PREPARED_STATEMENT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PreparedStatementNames")
            .getter(getter(BatchGetPreparedStatementRequest::preparedStatementNames))
            .setter(setter(Builder::preparedStatementNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreparedStatementNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(BatchGetPreparedStatementRequest::workGroup))
            .setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREPARED_STATEMENT_NAMES_FIELD, WORK_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> preparedStatementNames;

    private final String workGroup;

    private BatchGetPreparedStatementRequest(BuilderImpl builder) {
        super(builder);
        this.preparedStatementNames = builder.preparedStatementNames;
        this.workGroup = builder.workGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreparedStatementNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPreparedStatementNames() {
        return preparedStatementNames != null && !(preparedStatementNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of prepared statement names to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreparedStatementNames} method.
     * </p>
     * 
     * @return A list of prepared statement names to return.
     */
    public final List<String> preparedStatementNames() {
        return preparedStatementNames;
    }

    /**
     * <p>
     * The name of the workgroup to which the prepared statements belong.
     * </p>
     * 
     * @return The name of the workgroup to which the prepared statements belong.
     */
    public final String workGroup() {
        return workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPreparedStatementNames() ? preparedStatementNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPreparedStatementRequest)) {
            return false;
        }
        BatchGetPreparedStatementRequest other = (BatchGetPreparedStatementRequest) obj;
        return hasPreparedStatementNames() == other.hasPreparedStatementNames()
                && Objects.equals(preparedStatementNames(), other.preparedStatementNames())
                && Objects.equals(workGroup(), other.workGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetPreparedStatementRequest")
                .add("PreparedStatementNames", hasPreparedStatementNames() ? preparedStatementNames() : null)
                .add("WorkGroup", workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreparedStatementNames":
            return Optional.ofNullable(clazz.cast(preparedStatementNames()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreparedStatementNames", PREPARED_STATEMENT_NAMES_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPreparedStatementRequest, T> g) {
        return obj -> g.apply((BatchGetPreparedStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetPreparedStatementRequest> {
        /**
         * <p>
         * A list of prepared statement names to return.
         * </p>
         * 
         * @param preparedStatementNames
         *        A list of prepared statement names to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preparedStatementNames(Collection<String> preparedStatementNames);

        /**
         * <p>
         * A list of prepared statement names to return.
         * </p>
         * 
         * @param preparedStatementNames
         *        A list of prepared statement names to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preparedStatementNames(String... preparedStatementNames);

        /**
         * <p>
         * The name of the workgroup to which the prepared statements belong.
         * </p>
         * 
         * @param workGroup
         *        The name of the workgroup to which the prepared statements belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private List<String> preparedStatementNames = DefaultSdkAutoConstructList.getInstance();

        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPreparedStatementRequest model) {
            super(model);
            preparedStatementNames(model.preparedStatementNames);
            workGroup(model.workGroup);
        }

        public final Collection<String> getPreparedStatementNames() {
            if (preparedStatementNames instanceof SdkAutoConstructList) {
                return null;
            }
            return preparedStatementNames;
        }

        public final void setPreparedStatementNames(Collection<String> preparedStatementNames) {
            this.preparedStatementNames = PreparedStatementNameListCopier.copy(preparedStatementNames);
        }

        @Override
        public final Builder preparedStatementNames(Collection<String> preparedStatementNames) {
            this.preparedStatementNames = PreparedStatementNameListCopier.copy(preparedStatementNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatementNames(String... preparedStatementNames) {
            preparedStatementNames(Arrays.asList(preparedStatementNames));
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetPreparedStatementRequest build() {
            return new BatchGetPreparedStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
