/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EngineVersion;
import software.amazon.awssdk.services.athena.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(SessionSummary.getter(SessionSummary::sessionId)).setter(SessionSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SessionSummary.getter(SessionSummary::description)).setter(SessionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(SessionSummary.getter(SessionSummary::engineVersion)).setter(SessionSummary.setter(Builder::engineVersion)).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookVersion").getter(SessionSummary.getter(SessionSummary::notebookVersion)).setter(SessionSummary.setter(Builder::notebookVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()}).build();
    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(SessionSummary.getter(SessionSummary::status)).setter(SessionSummary.setter(Builder::status)).constructor(SessionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, DESCRIPTION_FIELD, ENGINE_VERSION_FIELD, NOTEBOOK_VERSION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final String description;
    private final EngineVersion engineVersion;
    private final String notebookVersion;
    private final SessionStatus status;

    private SessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.engineVersion = builder.engineVersion;
        this.notebookVersion = builder.notebookVersion;
        this.status = builder.status;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String description() {
        return this.description;
    }

    public final EngineVersion engineVersion() {
        return this.engineVersion;
    }

    public final String notebookVersion() {
        return this.notebookVersion;
    }

    public final SessionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSummary)) {
            return false;
        }
        SessionSummary other = (SessionSummary)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.notebookVersion(), other.notebookVersion()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"SessionSummary").add("SessionId", (Object)this.sessionId()).add("Description", (Object)this.description()).add("EngineVersion", (Object)this.engineVersion()).add("NotebookVersion", (Object)this.notebookVersion()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "NotebookVersion": {
                return Optional.ofNullable(clazz.cast(this.notebookVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NotebookVersion", NOTEBOOK_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionSummary, T> g) {
        return obj -> g.apply((SessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private String description;
        private EngineVersion engineVersion;
        private String notebookVersion;
        private SessionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSummary model) {
            this.sessionId(model.sessionId);
            this.description(model.description);
            this.engineVersion(model.engineVersion);
            this.notebookVersion(model.notebookVersion);
            this.status(model.status);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getNotebookVersion() {
            return this.notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        public SessionSummary build() {
            return new SessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionSummary> {
        public Builder sessionId(String var1);

        public Builder description(String var1);

        public Builder engineVersion(EngineVersion var1);

        default public Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return this.engineVersion((EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation(engineVersion)).build());
        }

        public Builder notebookVersion(String var1);

        public Builder status(SessionStatus var1);

        default public Builder status(Consumer<SessionStatus.Builder> status) {
            return this.status((SessionStatus)((SessionStatus.Builder)SessionStatus.builder().applyMutation(status)).build());
        }
    }
}

