/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.TableMetadata;
import software.amazon.awssdk.services.athena.model.TableMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableMetadataResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListTableMetadataResponse> {
    private static final SdkField<List<TableMetadata>> TABLE_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableMetadataList").getter(ListTableMetadataResponse.getter(ListTableMetadataResponse::tableMetadataList)).setter(ListTableMetadataResponse.setter(Builder::tableMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTableMetadataResponse.getter(ListTableMetadataResponse::nextToken)).setter(ListTableMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTableMetadataResponse.memberNameToFieldInitializer();
    private final List<TableMetadata> tableMetadataList;
    private final String nextToken;

    private ListTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.tableMetadataList = builder.tableMetadataList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTableMetadataList() {
        return this.tableMetadataList != null && !(this.tableMetadataList instanceof SdkAutoConstructList);
    }

    public final List<TableMetadata> tableMetadataList() {
        return this.tableMetadataList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableMetadataList() ? this.tableMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableMetadataResponse)) {
            return false;
        }
        ListTableMetadataResponse other = (ListTableMetadataResponse)((Object)obj);
        return this.hasTableMetadataList() == other.hasTableMetadataList() && Objects.equals(this.tableMetadataList(), other.tableMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableMetadataResponse").add("TableMetadataList", this.hasTableMetadataList() ? this.tableMetadataList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableMetadataList": {
                return Optional.ofNullable(clazz.cast(this.tableMetadataList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableMetadataList", TABLE_METADATA_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTableMetadataResponse, T> g) {
        return obj -> g.apply((ListTableMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<TableMetadata> tableMetadataList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableMetadataResponse model) {
            super(model);
            this.tableMetadataList(model.tableMetadataList);
            this.nextToken(model.nextToken);
        }

        public final List<TableMetadata.Builder> getTableMetadataList() {
            List<TableMetadata.Builder> result = TableMetadataListCopier.copyToBuilder(this.tableMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableMetadataList(Collection<TableMetadata.BuilderImpl> tableMetadataList) {
            this.tableMetadataList = TableMetadataListCopier.copyFromBuilder(tableMetadataList);
        }

        @Override
        public final Builder tableMetadataList(Collection<TableMetadata> tableMetadataList) {
            this.tableMetadataList = TableMetadataListCopier.copy(tableMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableMetadataList(TableMetadata ... tableMetadataList) {
            this.tableMetadataList(Arrays.asList(tableMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableMetadataList(Consumer<TableMetadata.Builder> ... tableMetadataList) {
            this.tableMetadataList(Stream.of(tableMetadataList).map(c -> (TableMetadata)((TableMetadata.Builder)TableMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTableMetadataResponse build() {
            return new ListTableMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableMetadataResponse> {
        public Builder tableMetadataList(Collection<TableMetadata> var1);

        public Builder tableMetadataList(TableMetadata ... var1);

        public Builder tableMetadataList(Consumer<TableMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

