/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.WorkGroupNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityAssignment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityAssignment> {
    private static final SdkField<List<String>> WORK_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkGroupNames").getter(CapacityAssignment.getter(CapacityAssignment::workGroupNames)).setter(CapacityAssignment.setter(Builder::workGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityAssignment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> workGroupNames;

    private CapacityAssignment(BuilderImpl builder) {
        this.workGroupNames = builder.workGroupNames;
    }

    public final boolean hasWorkGroupNames() {
        return this.workGroupNames != null && !(this.workGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> workGroupNames() {
        return this.workGroupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkGroupNames() ? this.workGroupNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAssignment)) {
            return false;
        }
        CapacityAssignment other = (CapacityAssignment)obj;
        return this.hasWorkGroupNames() == other.hasWorkGroupNames() && Objects.equals(this.workGroupNames(), other.workGroupNames());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityAssignment").add("WorkGroupNames", this.hasWorkGroupNames() ? this.workGroupNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkGroupNames": {
                return Optional.ofNullable(clazz.cast(this.workGroupNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("WorkGroupNames", WORK_GROUP_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityAssignment, T> g) {
        return obj -> g.apply((CapacityAssignment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> workGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAssignment model) {
            this.workGroupNames(model.workGroupNames);
        }

        public final Collection<String> getWorkGroupNames() {
            if (this.workGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workGroupNames;
        }

        public final void setWorkGroupNames(Collection<String> workGroupNames) {
            this.workGroupNames = WorkGroupNamesListCopier.copy(workGroupNames);
        }

        @Override
        public final Builder workGroupNames(Collection<String> workGroupNames) {
            this.workGroupNames = WorkGroupNamesListCopier.copy(workGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workGroupNames(String ... workGroupNames) {
            this.workGroupNames(Arrays.asList(workGroupNames));
            return this;
        }

        public CapacityAssignment build() {
            return new CapacityAssignment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityAssignment> {
        public Builder workGroupNames(Collection<String> var1);

        public Builder workGroupNames(String ... var1);
    }
}

