/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsRows;
import software.amazon.awssdk.services.athena.model.QueryRuntimeStatisticsTimeline;
import software.amazon.awssdk.services.athena.model.QueryStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRuntimeStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryRuntimeStatistics> {
    private static final SdkField<QueryRuntimeStatisticsTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Timeline").getter(QueryRuntimeStatistics.getter(QueryRuntimeStatistics::timeline)).setter(QueryRuntimeStatistics.setter(Builder::timeline)).constructor(QueryRuntimeStatisticsTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final SdkField<QueryRuntimeStatisticsRows> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rows").getter(QueryRuntimeStatistics.getter(QueryRuntimeStatistics::rows)).setter(QueryRuntimeStatistics.setter(Builder::rows)).constructor(QueryRuntimeStatisticsRows::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build()}).build();
    private static final SdkField<QueryStage> OUTPUT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputStage").getter(QueryRuntimeStatistics.getter(QueryRuntimeStatistics::outputStage)).setter(QueryRuntimeStatistics.setter(Builder::outputStage)).constructor(QueryStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputStage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMELINE_FIELD, ROWS_FIELD, OUTPUT_STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryRuntimeStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final QueryRuntimeStatisticsTimeline timeline;
    private final QueryRuntimeStatisticsRows rows;
    private final QueryStage outputStage;

    private QueryRuntimeStatistics(BuilderImpl builder) {
        this.timeline = builder.timeline;
        this.rows = builder.rows;
        this.outputStage = builder.outputStage;
    }

    public final QueryRuntimeStatisticsTimeline timeline() {
        return this.timeline;
    }

    public final QueryRuntimeStatisticsRows rows() {
        return this.rows;
    }

    public final QueryStage outputStage() {
        return this.outputStage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.rows());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRuntimeStatistics)) {
            return false;
        }
        QueryRuntimeStatistics other = (QueryRuntimeStatistics)obj;
        return Objects.equals(this.timeline(), other.timeline()) && Objects.equals(this.rows(), other.rows()) && Objects.equals(this.outputStage(), other.outputStage());
    }

    public final String toString() {
        return ToString.builder((String)"QueryRuntimeStatistics").add("Timeline", (Object)this.timeline()).add("Rows", (Object)this.rows()).add("OutputStage", (Object)this.outputStage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "OutputStage": {
                return Optional.ofNullable(clazz.cast(this.outputStage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timeline", TIMELINE_FIELD);
        map.put("Rows", ROWS_FIELD);
        map.put("OutputStage", OUTPUT_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryRuntimeStatistics, T> g) {
        return obj -> g.apply((QueryRuntimeStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private QueryRuntimeStatisticsTimeline timeline;
        private QueryRuntimeStatisticsRows rows;
        private QueryStage outputStage;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRuntimeStatistics model) {
            this.timeline(model.timeline);
            this.rows(model.rows);
            this.outputStage(model.outputStage);
        }

        public final QueryRuntimeStatisticsTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        public final void setTimeline(QueryRuntimeStatisticsTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(QueryRuntimeStatisticsTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final QueryRuntimeStatisticsRows.Builder getRows() {
            return this.rows != null ? this.rows.toBuilder() : null;
        }

        public final void setRows(QueryRuntimeStatisticsRows.BuilderImpl rows) {
            this.rows = rows != null ? rows.build() : null;
        }

        @Override
        public final Builder rows(QueryRuntimeStatisticsRows rows) {
            this.rows = rows;
            return this;
        }

        public final QueryStage.Builder getOutputStage() {
            return this.outputStage != null ? this.outputStage.toBuilder() : null;
        }

        public final void setOutputStage(QueryStage.BuilderImpl outputStage) {
            this.outputStage = outputStage != null ? outputStage.build() : null;
        }

        @Override
        public final Builder outputStage(QueryStage outputStage) {
            this.outputStage = outputStage;
            return this;
        }

        public QueryRuntimeStatistics build() {
            return new QueryRuntimeStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryRuntimeStatistics> {
        public Builder timeline(QueryRuntimeStatisticsTimeline var1);

        default public Builder timeline(Consumer<QueryRuntimeStatisticsTimeline.Builder> timeline) {
            return this.timeline((QueryRuntimeStatisticsTimeline)((QueryRuntimeStatisticsTimeline.Builder)QueryRuntimeStatisticsTimeline.builder().applyMutation(timeline)).build());
        }

        public Builder rows(QueryRuntimeStatisticsRows var1);

        default public Builder rows(Consumer<QueryRuntimeStatisticsRows.Builder> rows) {
            return this.rows((QueryRuntimeStatisticsRows)((QueryRuntimeStatisticsRows.Builder)QueryRuntimeStatisticsRows.builder().applyMutation(rows)).build());
        }

        public Builder outputStage(QueryStage var1);

        default public Builder outputStage(Consumer<QueryStage.Builder> outputStage) {
            return this.outputStage((QueryStage)((QueryStage.Builder)QueryStage.builder().applyMutation(outputStage)).build());
        }
    }
}

