/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.Datum;
import software.amazon.awssdk.services.athena.model._datumListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Row
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Row> {
    private static final SdkField<List<Datum>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Data").getter(Row.getter(Row::data)).setter(Row.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Datum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Data", DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Datum> data;

    private Row(BuilderImpl builder) {
        this.data = builder.data;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructList);
    }

    public final List<Datum> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return this.hasData() == other.hasData() && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"Row").add("Data", this.hasData() ? this.data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Datum> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            this.data(model.data);
        }

        public final List<Datum.Builder> getData() {
            List<Datum.Builder> result = _datumListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<Datum.BuilderImpl> data) {
            this.data = _datumListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<Datum> data) {
            this.data = _datumListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Datum ... data) {
            this.data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<Datum.Builder> ... data) {
            this.data(Stream.of(data).map(c -> (Datum)((Datum.Builder)Datum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Row build() {
            return new Row(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Row> {
        public Builder data(Collection<Datum> var1);

        public Builder data(Datum ... var1);

        public Builder data(Consumer<Datum.Builder> ... var1);
    }
}

