/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.CapacityAllocationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityAllocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityAllocation> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CapacityAllocation.getter(CapacityAllocation::statusAsString)).setter(CapacityAllocation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(CapacityAllocation.getter(CapacityAllocation::statusMessage)).setter(CapacityAllocation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestTime").getter(CapacityAllocation.getter(CapacityAllocation::requestTime)).setter(CapacityAllocation.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()}).build();
    private static final SdkField<Instant> REQUEST_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestCompletionTime").getter(CapacityAllocation.getter(CapacityAllocation::requestCompletionTime)).setter(CapacityAllocation.setter(Builder::requestCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCompletionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_MESSAGE_FIELD, REQUEST_TIME_FIELD, REQUEST_COMPLETION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("RequestTime", REQUEST_TIME_FIELD);
            this.put("RequestCompletionTime", REQUEST_COMPLETION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String statusMessage;
    private final Instant requestTime;
    private final Instant requestCompletionTime;

    private CapacityAllocation(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.requestTime = builder.requestTime;
        this.requestCompletionTime = builder.requestCompletionTime;
    }

    public final CapacityAllocationStatus status() {
        return CapacityAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant requestTime() {
        return this.requestTime;
    }

    public final Instant requestCompletionTime() {
        return this.requestCompletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCompletionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAllocation)) {
            return false;
        }
        CapacityAllocation other = (CapacityAllocation)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.requestCompletionTime(), other.requestCompletionTime());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityAllocation").add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("RequestTime", (Object)this.requestTime()).add("RequestCompletionTime", (Object)this.requestCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "RequestCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.requestCompletionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CapacityAllocation, T> g) {
        return obj -> g.apply((CapacityAllocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusMessage;
        private Instant requestTime;
        private Instant requestCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAllocation model) {
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.requestTime(model.requestTime);
            this.requestCompletionTime(model.requestCompletionTime);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getRequestCompletionTime() {
            return this.requestCompletionTime;
        }

        public final void setRequestCompletionTime(Instant requestCompletionTime) {
            this.requestCompletionTime = requestCompletionTime;
        }

        @Override
        public final Builder requestCompletionTime(Instant requestCompletionTime) {
            this.requestCompletionTime = requestCompletionTime;
            return this;
        }

        public CapacityAllocation build() {
            return new CapacityAllocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityAllocation> {
        public Builder status(String var1);

        public Builder status(CapacityAllocationStatus var1);

        public Builder statusMessage(String var1);

        public Builder requestTime(Instant var1);

        public Builder requestCompletionTime(Instant var1);
    }
}

