/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableMetadataRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, GetTableMetadataRequest> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogName").getter(GetTableMetadataRequest.getter(GetTableMetadataRequest::catalogName)).setter(GetTableMetadataRequest.setter(Builder::catalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetTableMetadataRequest.getter(GetTableMetadataRequest::databaseName)).setter(GetTableMetadataRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetTableMetadataRequest.getter(GetTableMetadataRequest::tableName)).setter(GetTableMetadataRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(GetTableMetadataRequest.getter(GetTableMetadataRequest::workGroup)).setter(GetTableMetadataRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, WORK_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CatalogName", CATALOG_NAME_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("WorkGroup", WORK_GROUP_FIELD);
        }
    });
    private final String catalogName;
    private final String databaseName;
    private final String tableName;
    private final String workGroup;

    private GetTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.catalogName = builder.catalogName;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.workGroup = builder.workGroup;
    }

    public final String catalogName() {
        return this.catalogName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMetadataRequest)) {
            return false;
        }
        GetTableMetadataRequest other = (GetTableMetadataRequest)((Object)obj);
        return Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.workGroup(), other.workGroup());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableMetadataRequest").add("CatalogName", (Object)this.catalogName()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("WorkGroup", (Object)this.workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogName": {
                return Optional.ofNullable(clazz.cast(this.catalogName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableMetadataRequest, T> g) {
        return obj -> g.apply((GetTableMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String catalogName;
        private String databaseName;
        private String tableName;
        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMetadataRequest model) {
            super(model);
            this.catalogName(model.catalogName);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.workGroup(model.workGroup);
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableMetadataRequest build() {
            return new GetTableMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableMetadataRequest> {
        public Builder catalogName(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder workGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

