/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.SessionAlreadyExistsException;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.paginators.GetQueryResultsIterable;
import software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesIterable;
import software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsIterable;
import software.amazon.awssdk.services.athena.paginators.ListDataCatalogsIterable;
import software.amazon.awssdk.services.athena.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.athena.paginators.ListEngineVersionsIterable;
import software.amazon.awssdk.services.athena.paginators.ListExecutorsIterable;
import software.amazon.awssdk.services.athena.paginators.ListNamedQueriesIterable;
import software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsIterable;
import software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsIterable;
import software.amazon.awssdk.services.athena.paginators.ListSessionsIterable;
import software.amazon.awssdk.services.athena.paginators.ListTableMetadataIterable;
import software.amazon.awssdk.services.athena.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.athena.paginators.ListWorkGroupsIterable;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePresignedNotebookUrlRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeletePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ExportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionCodeRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryRuntimeStatisticsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ImportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListApplicationDpuSizesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCalculationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListExecutorsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListPreparedStatementsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAthenaClient
implements AthenaClient {
    private static final Logger log = Logger.loggerFor(DefaultAthenaClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "athena";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetNamedQueryResponse batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, batchGetNamedQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetNamedQuery");
            BatchGetNamedQueryResponse batchGetNamedQueryResponse = (BatchGetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetNamedQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$batchGetNamedQuery$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetPreparedStatementResponse batchGetPreparedStatement(BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetPreparedStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, batchGetPreparedStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetPreparedStatement");
            BatchGetPreparedStatementResponse batchGetPreparedStatementResponse = (BatchGetPreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetPreparedStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetPreparedStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetPreparedStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$batchGetPreparedStatement$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetQueryExecutionResponse batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, batchGetQueryExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetQueryExecution");
            BatchGetQueryExecutionResponse batchGetQueryExecutionResponse = (BatchGetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetQueryExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$batchGetQueryExecution$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataCatalogResponse createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createDataCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataCatalog");
            CreateDataCatalogResponse createDataCatalogResponse = (CreateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createDataCatalog$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNamedQueryResponse createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createNamedQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNamedQuery");
            CreateNamedQueryResponse createNamedQueryResponse = (CreateNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNamedQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createNamedQuery$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNotebookResponse createNotebook(CreateNotebookRequest createNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNotebookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createNotebookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNotebook");
            CreateNotebookResponse createNotebookResponse = (CreateNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNotebook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNotebookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNotebookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNotebookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createNotebook$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePreparedStatementResponse createPreparedStatement(CreatePreparedStatementRequest createPreparedStatementRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePreparedStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createPreparedStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePreparedStatement");
            CreatePreparedStatementResponse createPreparedStatementResponse = (CreatePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePreparedStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPreparedStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePreparedStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createPreparedStatement$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePresignedNotebookUrlResponse createPresignedNotebookUrl(CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePresignedNotebookUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createPresignedNotebookUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePresignedNotebookUrl");
            CreatePresignedNotebookUrlResponse createPresignedNotebookUrlResponse = (CreatePresignedNotebookUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePresignedNotebookUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPresignedNotebookUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePresignedNotebookUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPresignedNotebookUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createPresignedNotebookUrl$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkGroupResponse createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createWorkGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkGroup");
            CreateWorkGroupResponse createWorkGroupResponse = (CreateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$createWorkGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataCatalogResponse deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteDataCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataCatalog");
            DeleteDataCatalogResponse deleteDataCatalogResponse = (DeleteDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$deleteDataCatalog$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamedQueryResponse deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteNamedQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamedQuery");
            DeleteNamedQueryResponse deleteNamedQueryResponse = (DeleteNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamedQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$deleteNamedQuery$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotebookResponse deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNotebookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteNotebookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNotebook");
            DeleteNotebookResponse deleteNotebookResponse = (DeleteNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotebook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotebookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNotebookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNotebookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$deleteNotebook$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePreparedStatementResponse deletePreparedStatement(DeletePreparedStatementRequest deletePreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePreparedStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deletePreparedStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePreparedStatement");
            DeletePreparedStatementResponse deletePreparedStatementResponse = (DeletePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePreparedStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePreparedStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePreparedStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$deletePreparedStatement$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkGroupResponse deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkGroup");
            DeleteWorkGroupResponse deleteWorkGroupResponse = (DeleteWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$deleteWorkGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportNotebookResponse exportNotebook(ExportNotebookRequest exportNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportNotebookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, exportNotebookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportNotebook");
            ExportNotebookResponse exportNotebookResponse = (ExportNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportNotebook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportNotebookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportNotebookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportNotebookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$exportNotebook$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionResponse getCalculationExecution(GetCalculationExecutionRequest getCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getCalculationExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCalculationExecution");
            GetCalculationExecutionResponse getCalculationExecutionResponse = (GetCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCalculationExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCalculationExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getCalculationExecution$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionCodeResponse getCalculationExecutionCode(GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionCodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getCalculationExecutionCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCalculationExecutionCode");
            GetCalculationExecutionCodeResponse getCalculationExecutionCodeResponse = (GetCalculationExecutionCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionCode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCalculationExecutionCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCalculationExecutionCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCalculationExecutionCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getCalculationExecutionCode$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionStatusResponse getCalculationExecutionStatus(GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getCalculationExecutionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCalculationExecutionStatus");
            GetCalculationExecutionStatusResponse getCalculationExecutionStatusResponse = (GetCalculationExecutionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCalculationExecutionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCalculationExecutionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCalculationExecutionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getCalculationExecutionStatus$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataCatalogResponse getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getDataCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataCatalog");
            GetDataCatalogResponse getDataCatalogResponse = (GetDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getDataCatalog$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatabase");
            GetDatabaseResponse getDatabaseResponse = (GetDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getDatabase$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamedQueryResponse getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getNamedQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamedQuery");
            GetNamedQueryResponse getNamedQueryResponse = (GetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamedQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getNamedQuery$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNotebookMetadataResponse getNotebookMetadata(GetNotebookMetadataRequest getNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNotebookMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getNotebookMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNotebookMetadata");
            GetNotebookMetadataResponse getNotebookMetadataResponse = (GetNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNotebookMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNotebookMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNotebookMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getNotebookMetadata$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPreparedStatementResponse getPreparedStatement(GetPreparedStatementRequest getPreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPreparedStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getPreparedStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPreparedStatement");
            GetPreparedStatementResponse getPreparedStatementResponse = (GetPreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPreparedStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPreparedStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPreparedStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getPreparedStatement$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryExecutionResponse getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getQueryExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryExecution");
            GetQueryExecutionResponse getQueryExecutionResponse = (GetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getQueryExecution$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getQueryResults$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetQueryResultsIterable getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        return new GetQueryResultsIterable(this, this.applyPaginatorUserAgent(getQueryResultsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryRuntimeStatisticsResponse getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryRuntimeStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getQueryRuntimeStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryRuntimeStatistics");
            GetQueryRuntimeStatisticsResponse getQueryRuntimeStatisticsResponse = (GetQueryRuntimeStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryRuntimeStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryRuntimeStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryRuntimeStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryRuntimeStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getQueryRuntimeStatistics$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSession");
            GetSessionResponse getSessionResponse = (GetSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getSession$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionStatusResponse getSessionStatus(GetSessionStatusRequest getSessionStatusRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getSessionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSessionStatus");
            GetSessionStatusResponse getSessionStatusResponse = (GetSessionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSessionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSessionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSessionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getSessionStatus$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableMetadataResponse getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getTableMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableMetadata");
            GetTableMetadataResponse getTableMetadataResponse = (GetTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTableMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTableMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getTableMetadata$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkGroupResponse getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getWorkGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkGroup");
            GetWorkGroupResponse getWorkGroupResponse = (GetWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$getWorkGroup$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportNotebookResponse importNotebook(ImportNotebookRequest importNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportNotebookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, importNotebookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportNotebook");
            ImportNotebookResponse importNotebookResponse = (ImportNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportNotebook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importNotebookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportNotebookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importNotebookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$importNotebook$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationDpuSizesResponse listApplicationDPUSizes(ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationDpuSizesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listApplicationDpuSizesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationDPUSizes");
            ListApplicationDpuSizesResponse listApplicationDpuSizesResponse = (ListApplicationDpuSizesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationDPUSizes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationDpuSizesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationDpuSizesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationDpuSizesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listApplicationDPUSizes$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationDPUSizesIterable listApplicationDPUSizesPaginator(ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        return new ListApplicationDPUSizesIterable(this, this.applyPaginatorUserAgent(listApplicationDpuSizesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCalculationExecutionsResponse listCalculationExecutions(ListCalculationExecutionsRequest listCalculationExecutionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCalculationExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listCalculationExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCalculationExecutions");
            ListCalculationExecutionsResponse listCalculationExecutionsResponse = (ListCalculationExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCalculationExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCalculationExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCalculationExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCalculationExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listCalculationExecutions$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCalculationExecutionsIterable listCalculationExecutionsPaginator(ListCalculationExecutionsRequest listCalculationExecutionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        return new ListCalculationExecutionsIterable(this, this.applyPaginatorUserAgent(listCalculationExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataCatalogsResponse listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCatalogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listDataCatalogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataCatalogs");
            ListDataCatalogsResponse listDataCatalogsResponse = (ListDataCatalogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCatalogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataCatalogsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataCatalogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataCatalogsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listDataCatalogs$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDataCatalogsIterable listDataCatalogsPaginator(ListDataCatalogsRequest listDataCatalogsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListDataCatalogsIterable(this, this.applyPaginatorUserAgent(listDataCatalogsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            ListDatabasesResponse listDatabasesResponse = (ListDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listDatabases$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        return new ListDatabasesIterable(this, this.applyPaginatorUserAgent(listDatabasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEngineVersionsResponse listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEngineVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEngineVersions");
            ListEngineVersionsResponse listEngineVersionsResponse = (ListEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEngineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEngineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listEngineVersions$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEngineVersionsIterable listEngineVersionsPaginator(ListEngineVersionsRequest listEngineVersionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListEngineVersionsIterable(this, this.applyPaginatorUserAgent(listEngineVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExecutorsResponse listExecutors(ListExecutorsRequest listExecutorsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listExecutorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExecutors");
            ListExecutorsResponse listExecutorsResponse = (ListExecutorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExecutorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExecutorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExecutorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listExecutors$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExecutorsIterable listExecutorsPaginator(ListExecutorsRequest listExecutorsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        return new ListExecutorsIterable(this, this.applyPaginatorUserAgent(listExecutorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNamedQueriesResponse listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamedQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listNamedQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNamedQueries");
            ListNamedQueriesResponse listNamedQueriesResponse = (ListNamedQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamedQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNamedQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNamedQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNamedQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listNamedQueries$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNamedQueriesIterable listNamedQueriesPaginator(ListNamedQueriesRequest listNamedQueriesRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListNamedQueriesIterable(this, this.applyPaginatorUserAgent(listNamedQueriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotebookMetadataResponse listNotebookMetadata(ListNotebookMetadataRequest listNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listNotebookMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNotebookMetadata");
            ListNotebookMetadataResponse listNotebookMetadataResponse = (ListNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotebookMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNotebookMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listNotebookMetadata$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest listNotebookSessionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listNotebookSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNotebookSessions");
            ListNotebookSessionsResponse listNotebookSessionsResponse = (ListNotebookSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotebookSessionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNotebookSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNotebookSessionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listNotebookSessions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPreparedStatementsResponse listPreparedStatements(ListPreparedStatementsRequest listPreparedStatementsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPreparedStatementsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listPreparedStatementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPreparedStatements");
            ListPreparedStatementsResponse listPreparedStatementsResponse = (ListPreparedStatementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPreparedStatements").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPreparedStatementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPreparedStatementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPreparedStatementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listPreparedStatements$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPreparedStatementsIterable listPreparedStatementsPaginator(ListPreparedStatementsRequest listPreparedStatementsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListPreparedStatementsIterable(this, this.applyPaginatorUserAgent(listPreparedStatementsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueryExecutionsResponse listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueryExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listQueryExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueryExecutions");
            ListQueryExecutionsResponse listQueryExecutionsResponse = (ListQueryExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueryExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListQueryExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQueryExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listQueryExecutions$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListQueryExecutionsIterable listQueryExecutionsPaginator(ListQueryExecutionsRequest listQueryExecutionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListQueryExecutionsIterable(this, this.applyPaginatorUserAgent(listQueryExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSessionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSessions");
            ListSessionsResponse listSessionsResponse = (ListSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSessions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSessionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSessionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listSessions$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSessionsIterable listSessionsPaginator(ListSessionsRequest listSessionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        return new ListSessionsIterable(this, this.applyPaginatorUserAgent(listSessionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableMetadataResponse listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listTableMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableMetadata");
            ListTableMetadataResponse listTableMetadataResponse = (ListTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTableMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listTableMetadata$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTableMetadataIterable listTableMetadataPaginator(ListTableMetadataRequest listTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        return new ListTableMetadataIterable(this, this.applyPaginatorUserAgent(listTableMetadataRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listTagsForResource$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkGroupsResponse listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listWorkGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkGroups");
            ListWorkGroupsResponse listWorkGroupsResponse = (ListWorkGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$listWorkGroups$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkGroupsIterable listWorkGroupsPaginator(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListWorkGroupsIterable(this, this.applyPaginatorUserAgent(listWorkGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCalculationExecutionResponse startCalculationExecution(StartCalculationExecutionRequest startCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCalculationExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, startCalculationExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCalculationExecution");
            StartCalculationExecutionResponse startCalculationExecutionResponse = (StartCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCalculationExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCalculationExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCalculationExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$startCalculationExecution$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryExecutionResponse startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, startQueryExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQueryExecution");
            StartQueryExecutionResponse startQueryExecutionResponse = (StartQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startQueryExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$startQueryExecution$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSessionResponse startSession(StartSessionRequest startSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, SessionAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, startSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSession");
            StartSessionResponse startSessionResponse = (StartSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$startSession$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopCalculationExecutionResponse stopCalculationExecution(StopCalculationExecutionRequest stopCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCalculationExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, stopCalculationExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopCalculationExecution");
            StopCalculationExecutionResponse stopCalculationExecutionResponse = (StopCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCalculationExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopCalculationExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopCalculationExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$stopCalculationExecution$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopQueryExecutionResponse stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, stopQueryExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopQueryExecution");
            StopQueryExecutionResponse stopQueryExecutionResponse = (StopQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopQueryExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$stopQueryExecution$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$tagResource$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateSessionResponse terminateSession(TerminateSessionRequest terminateSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, terminateSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateSession");
            TerminateSessionResponse terminateSessionResponse = (TerminateSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$terminateSession$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$untagResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataCatalogResponse updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateDataCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataCatalog");
            UpdateDataCatalogResponse updateDataCatalogResponse = (UpdateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updateDataCatalog$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNamedQueryResponse updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateNamedQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNamedQuery");
            UpdateNamedQueryResponse updateNamedQueryResponse = (UpdateNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNamedQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updateNamedQuery$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotebookResponse updateNotebook(UpdateNotebookRequest updateNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateNotebookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNotebook");
            UpdateNotebookResponse updateNotebookResponse = (UpdateNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNotebookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNotebookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNotebookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updateNotebook$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotebookMetadataResponse updateNotebookMetadata(UpdateNotebookMetadataRequest updateNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateNotebookMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNotebookMetadata");
            UpdateNotebookMetadataResponse updateNotebookMetadataResponse = (UpdateNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebookMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNotebookMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNotebookMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updateNotebookMetadata$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePreparedStatementResponse updatePreparedStatement(UpdatePreparedStatementRequest updatePreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePreparedStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updatePreparedStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePreparedStatement");
            UpdatePreparedStatementResponse updatePreparedStatementResponse = (UpdatePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePreparedStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePreparedStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePreparedStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updatePreparedStatement$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkGroupResponse updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateWorkGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkGroup");
            UpdateWorkGroupResponse updateWorkGroupResponse = (UpdateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAthenaClient.lambda$updateWorkGroup$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AthenaException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MetadataException").exceptionBuilderSupplier(MetadataException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").exceptionBuilderSupplier(SessionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AthenaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.1").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AthenaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateWorkGroup$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePreparedStatement$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNotebookMetadata$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNotebook$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNamedQuery$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataCatalog$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateSession$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopQueryExecution$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopCalculationExecution$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSession$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startQueryExecution$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCalculationExecution$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkGroups$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableMetadata$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSessions$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQueryExecutions$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPreparedStatements$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNotebookSessions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNotebookMetadata$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNamedQueries$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExecutors$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEngineVersions$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatabases$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataCatalogs$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCalculationExecutions$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationDPUSizes$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importNotebook$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkGroup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableMetadata$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSessionStatus$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSession$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryRuntimeStatistics$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryResults$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryExecution$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPreparedStatement$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNotebookMetadata$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamedQuery$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatabase$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataCatalog$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCalculationExecutionStatus$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCalculationExecutionCode$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCalculationExecution$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportNotebook$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePreparedStatement$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNotebook$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamedQuery$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataCatalog$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPresignedNotebookUrl$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPreparedStatement$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNotebook$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNamedQuery$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataCatalog$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetQueryExecution$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetPreparedStatement$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetNamedQuery$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

