/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;

public class ListEngineVersionsIterable
implements SdkIterable<ListEngineVersionsResponse> {
    private final AthenaClient client;
    private final ListEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngineVersionsIterable(AthenaClient client, ListEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEngineVersionsResponseFetcher();
    }

    public Iterator<ListEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEngineVersionsResponseFetcher
    implements SyncPageFetcher<ListEngineVersionsResponse> {
        private ListEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngineVersionsResponse nextPage(ListEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEngineVersionsIterable.this.client.listEngineVersions(ListEngineVersionsIterable.this.firstRequest);
            }
            return ListEngineVersionsIterable.this.client.listEngineVersions((ListEngineVersionsRequest)((Object)ListEngineVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

