/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultConfiguration> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(ResultConfiguration.getter(ResultConfiguration::outputLocation)).setter(ResultConfiguration.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ResultConfiguration.getter(ResultConfiguration::encryptionConfiguration)).setter(ResultConfiguration.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputLocation;
    private final EncryptionConfiguration encryptionConfiguration;

    private ResultConfiguration(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfiguration)) {
            return false;
        }
        ResultConfiguration other = (ResultConfiguration)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ResultConfiguration").add("OutputLocation", (Object)this.outputLocation()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultConfiguration, T> g) {
        return obj -> g.apply((ResultConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfiguration model) {
            this.outputLocation(model.outputLocation);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        @Transient
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public ResultConfiguration build() {
            return new ResultConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultConfiguration> {
        public Builder outputLocation(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

