/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.Database;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;

public class ListDatabasesIterable
implements SdkIterable<ListDatabasesResponse> {
    private final AthenaClient client;
    private final ListDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatabasesIterable(AthenaClient client, ListDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatabasesResponseFetcher();
    }

    public Iterator<ListDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Database> databaseList() {
        Function<ListDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.databaseList() != null) {
                return response.databaseList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatabasesResponseFetcher
    implements SyncPageFetcher<ListDatabasesResponse> {
        private ListDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatabasesResponse nextPage(ListDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListDatabasesIterable.this.client.listDatabases(ListDatabasesIterable.this.firstRequest);
            }
            return ListDatabasesIterable.this.client.listDatabases((ListDatabasesRequest)((Object)ListDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

