/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNamedQueryRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, GetNamedQueryRequest> {
    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamedQueryId").getter(GetNamedQueryRequest.getter(GetNamedQueryRequest::namedQueryId)).setter(GetNamedQueryRequest.setter(Builder::namedQueryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_ID_FIELD));
    private final String namedQueryId;

    private GetNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryId = builder.namedQueryId;
    }

    public final String namedQueryId() {
        return this.namedQueryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namedQueryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamedQueryRequest)) {
            return false;
        }
        GetNamedQueryRequest other = (GetNamedQueryRequest)((Object)obj);
        return Objects.equals(this.namedQueryId(), other.namedQueryId());
    }

    public final String toString() {
        return ToString.builder((String)"GetNamedQueryRequest").add("NamedQueryId", (Object)this.namedQueryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryId": {
                return Optional.ofNullable(clazz.cast(this.namedQueryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamedQueryRequest, T> g) {
        return obj -> g.apply((GetNamedQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String namedQueryId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamedQueryRequest model) {
            super(model);
            this.namedQueryId(model.namedQueryId);
        }

        public final String getNamedQueryId() {
            return this.namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNamedQueryRequest build() {
            return new GetNamedQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNamedQueryRequest> {
        public Builder namedQueryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

