/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.model.Row;
import software.amazon.awssdk.services.athena.transform.DatumUnmarshaller;

public class RowUnmarshaller
implements Unmarshaller<Row, JsonUnmarshallerContext> {
    private static final RowUnmarshaller INSTANCE = new RowUnmarshaller();

    public Row unmarshall(JsonUnmarshallerContext context) throws Exception {
        Row.Builder rowBuilder = Row.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    rowBuilder.data(new ListUnmarshaller((Unmarshaller)DatumUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Row)rowBuilder.build();
    }

    public static RowUnmarshaller getInstance() {
        return INSTANCE;
    }
}

