/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;

@SdkInternalApi
public class ResultConfigurationMarshaller {
    private static final MarshallingInfo<String> OUTPUTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputLocation").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").build();
    private static final ResultConfigurationMarshaller INSTANCE = new ResultConfigurationMarshaller();

    public static ResultConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultConfiguration resultConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (resultConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resultConfiguration.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)resultConfiguration.encryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

