/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatistics;

@SdkInternalApi
public class QueryExecutionStatisticsMarshaller {
    private static final MarshallingInfo<Long> ENGINEEXECUTIONTIMEINMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineExecutionTimeInMillis").build();
    private static final MarshallingInfo<Long> DATASCANNEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataScannedInBytes").build();
    private static final QueryExecutionStatisticsMarshaller INSTANCE = new QueryExecutionStatisticsMarshaller();

    public static QueryExecutionStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QueryExecutionStatistics queryExecutionStatistics, ProtocolMarshaller protocolMarshaller) {
        if (queryExecutionStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)queryExecutionStatistics.engineExecutionTimeInMillis(), ENGINEEXECUTIONTIMEINMILLIS_BINDING);
            protocolMarshaller.marshall((Object)queryExecutionStatistics.dataScannedInBytes(), DATASCANNEDINBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

