/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;

public final class GetQueryResultsPaginator
implements SdkIterable<GetQueryResultsResponse> {
    private final AthenaClient client;
    private final GetQueryResultsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetQueryResultsPaginator(AthenaClient client, GetQueryResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetQueryResultsResponseFetcher();
    }

    public Iterator<GetQueryResultsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetQueryResultsResponseFetcher
    implements NextPageFetcher<GetQueryResultsResponse> {
        private GetQueryResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetQueryResultsResponse nextPage(GetQueryResultsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsPaginator.this.client.getQueryResults(GetQueryResultsPaginator.this.firstRequest);
            }
            return GetQueryResultsPaginator.this.client.getQueryResults((GetQueryResultsRequest)((Object)GetQueryResultsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

