/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatistics;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatus;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.transform.QueryExecutionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecution> {
    private final String queryExecutionId;
    private final String query;
    private final ResultConfiguration resultConfiguration;
    private final QueryExecutionContext queryExecutionContext;
    private final QueryExecutionStatus status;
    private final QueryExecutionStatistics statistics;

    private QueryExecution(BuilderImpl builder) {
        this.queryExecutionId = builder.queryExecutionId;
        this.query = builder.query;
        this.resultConfiguration = builder.resultConfiguration;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.status = builder.status;
        this.statistics = builder.statistics;
    }

    public String queryExecutionId() {
        return this.queryExecutionId;
    }

    public String query() {
        return this.query;
    }

    public ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public QueryExecutionStatus status() {
        return this.status;
    }

    public QueryExecutionStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecution)) {
            return false;
        }
        QueryExecution other = (QueryExecution)obj;
        return Objects.equals(this.queryExecutionId(), other.queryExecutionId()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.queryExecutionContext(), other.queryExecutionContext()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statistics(), other.statistics());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecution").add("QueryExecutionId", (Object)this.queryExecutionId()).add("Query", (Object)this.query()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("QueryExecutionContext", (Object)this.queryExecutionContext()).add("Status", (Object)this.status()).add("Statistics", (Object)this.statistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionId": {
                return Optional.of(clazz.cast(this.queryExecutionId()));
            }
            case "Query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "ResultConfiguration": {
                return Optional.of(clazz.cast(this.resultConfiguration()));
            }
            case "QueryExecutionContext": {
                return Optional.of(clazz.cast(this.queryExecutionContext()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Statistics": {
                return Optional.of(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryExecutionId;
        private String query;
        private ResultConfiguration resultConfiguration;
        private QueryExecutionContext queryExecutionContext;
        private QueryExecutionStatus status;
        private QueryExecutionStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecution model) {
            this.queryExecutionId(model.queryExecutionId);
            this.query(model.query);
            this.resultConfiguration(model.resultConfiguration);
            this.queryExecutionContext(model.queryExecutionContext);
            this.status(model.status);
            this.statistics(model.statistics);
        }

        public final String getQueryExecutionId() {
            return this.queryExecutionId;
        }

        @Override
        public final Builder queryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
            return this;
        }

        public final void setQueryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        public final QueryExecutionContext.Builder getQueryExecutionContext() {
            return this.queryExecutionContext != null ? this.queryExecutionContext.toBuilder() : null;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final void setQueryExecutionContext(QueryExecutionContext.BuilderImpl queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext != null ? queryExecutionContext.build() : null;
        }

        public final QueryExecutionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(QueryExecutionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(QueryExecutionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final QueryExecutionStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(QueryExecutionStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(QueryExecutionStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public QueryExecution build() {
            return new QueryExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecution> {
        public Builder queryExecutionId(String var1);

        public Builder query(String var1);

        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().apply(resultConfiguration)).build());
        }

        public Builder queryExecutionContext(QueryExecutionContext var1);

        default public Builder queryExecutionContext(Consumer<QueryExecutionContext.Builder> queryExecutionContext) {
            return this.queryExecutionContext((QueryExecutionContext)((QueryExecutionContext.Builder)QueryExecutionContext.builder().apply(queryExecutionContext)).build());
        }

        public Builder status(QueryExecutionStatus var1);

        default public Builder status(Consumer<QueryExecutionStatus.Builder> status) {
            return this.status((QueryExecutionStatus)((QueryExecutionStatus.Builder)QueryExecutionStatus.builder().apply(status)).build());
        }

        public Builder statistics(QueryExecutionStatistics var1);

        default public Builder statistics(Consumer<QueryExecutionStatistics.Builder> statistics) {
            return this.statistics((QueryExecutionStatistics)((QueryExecutionStatistics.Builder)QueryExecutionStatistics.builder().apply(statistics)).build());
        }
    }
}

