/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNamedQueryRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, CreateNamedQueryRequest> {
    private final String name;
    private final String description;
    private final String database;
    private final String queryString;
    private final String clientRequestToken;

    private CreateNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String database() {
        return this.database;
    }

    public String queryString() {
        return this.queryString;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNamedQueryRequest)) {
            return false;
        }
        CreateNamedQueryRequest other = (CreateNamedQueryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.database() != null) {
            sb.append("Database: ").append(this.database()).append(",");
        }
        if (this.queryString() != null) {
            sb.append("QueryString: ").append(this.queryString()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Database": {
                return Optional.of(clazz.cast(this.database()));
            }
            case "QueryString": {
                return Optional.of(clazz.cast(this.queryString()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String database;
        private String queryString;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNamedQueryRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.database(model.database);
            this.queryString(model.queryString);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateNamedQueryRequest build() {
            return new CreateNamedQueryRequest(this);
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    CopyableBuilder<Builder, CreateNamedQueryRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder database(String var1);

        public Builder queryString(String var1);

        public Builder clientRequestToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

