/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;

public final class ListQueryExecutionsPaginator
implements SdkIterable<ListQueryExecutionsResponse> {
    private final AthenaClient client;
    private final ListQueryExecutionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListQueryExecutionsPaginator(AthenaClient client, ListQueryExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueryExecutionsResponseFetcher();
    }

    public Iterator<ListQueryExecutionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListQueryExecutionsResponseFetcher
    implements NextPageFetcher<ListQueryExecutionsResponse> {
        private ListQueryExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryExecutionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListQueryExecutionsResponse nextPage(ListQueryExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryExecutionsPaginator.this.client.listQueryExecutions(ListQueryExecutionsPaginator.this.firstRequest);
            }
            return ListQueryExecutionsPaginator.this.client.listQueryExecutions((ListQueryExecutionsRequest)((Object)ListQueryExecutionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

