/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetQueryExecutionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
    private final List<String> queryExecutionIds;

    private BatchGetQueryExecutionRequest(BuilderImpl builder) {
        this.queryExecutionIds = builder.queryExecutionIds;
    }

    public List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionRequest)) {
            return false;
        }
        BatchGetQueryExecutionRequest other = (BatchGetQueryExecutionRequest)((Object)obj);
        return Objects.equals(this.queryExecutionIds(), other.queryExecutionIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.queryExecutionIds() != null) {
            sb.append("QueryExecutionIds: ").append(this.queryExecutionIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionIds": {
                return Optional.of(clazz.cast(this.queryExecutionIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionRequest model) {
            this.queryExecutionIds(model.queryExecutionIds);
        }

        public final Collection<String> getQueryExecutionIds() {
            return this.queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        public BatchGetQueryExecutionRequest build() {
            return new BatchGetQueryExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);
    }
}

