/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.athena.model.NamedQueryIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetNamedQueryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetNamedQueryRequest> {
    private final List<String> namedQueryIds;

    private BatchGetNamedQueryRequest(BuilderImpl builder) {
        this.namedQueryIds = builder.namedQueryIds;
    }

    public List<String> namedQueryIds() {
        return this.namedQueryIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namedQueryIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryRequest)) {
            return false;
        }
        BatchGetNamedQueryRequest other = (BatchGetNamedQueryRequest)((Object)obj);
        return Objects.equals(this.namedQueryIds(), other.namedQueryIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namedQueryIds() != null) {
            sb.append("NamedQueryIds: ").append(this.namedQueryIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryIds": {
                return Optional.of(clazz.cast(this.namedQueryIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> namedQueryIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryRequest model) {
            this.namedQueryIds(model.namedQueryIds);
        }

        public final Collection<String> getNamedQueryIds() {
            return this.namedQueryIds;
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String ... namedQueryIds) {
            this.namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        public BatchGetNamedQueryRequest build() {
            return new BatchGetNamedQueryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetNamedQueryRequest> {
        public Builder namedQueryIds(Collection<String> var1);

        public Builder namedQueryIds(String ... var1);
    }
}

