/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.UnprocessedNamedQueryIdMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnprocessedNamedQueryId
implements StructuredPojo,
ToCopyableBuilder<Builder, UnprocessedNamedQueryId> {
    private final String namedQueryId;
    private final String errorCode;
    private final String errorMessage;

    private UnprocessedNamedQueryId(BuilderImpl builder) {
        this.namedQueryId = builder.namedQueryId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String namedQueryId() {
        return this.namedQueryId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namedQueryId() == null ? 0 : this.namedQueryId().hashCode());
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedNamedQueryId)) {
            return false;
        }
        UnprocessedNamedQueryId other = (UnprocessedNamedQueryId)obj;
        if (other.namedQueryId() == null ^ this.namedQueryId() == null) {
            return false;
        }
        if (other.namedQueryId() != null && !other.namedQueryId().equals(this.namedQueryId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namedQueryId() != null) {
            sb.append("NamedQueryId: ").append(this.namedQueryId()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryId": {
                return Optional.of(clazz.cast(this.namedQueryId()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnprocessedNamedQueryIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String namedQueryId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedNamedQueryId model) {
            this.namedQueryId(model.namedQueryId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getNamedQueryId() {
            return this.namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public UnprocessedNamedQueryId build() {
            return new UnprocessedNamedQueryId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnprocessedNamedQueryId> {
        public Builder namedQueryId(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

