/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.transform.ColumnInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ColumnInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ColumnInfo> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String name;
    private final String label;
    private final String type;
    private final Integer precision;
    private final Integer scale;
    private final String nullable;
    private final Boolean caseSensitive;

    private ColumnInfo(BuilderImpl builder) {
        this.catalogName = builder.catalogName;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.name = builder.name;
        this.label = builder.label;
        this.type = builder.type;
        this.precision = builder.precision;
        this.scale = builder.scale;
        this.nullable = builder.nullable;
        this.caseSensitive = builder.caseSensitive;
    }

    public String catalogName() {
        return this.catalogName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public String type() {
        return this.type;
    }

    public Integer precision() {
        return this.precision;
    }

    public Integer scale() {
        return this.scale;
    }

    public String nullable() {
        return this.nullable;
    }

    public Boolean caseSensitive() {
        return this.caseSensitive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.catalogName() == null ? 0 : this.catalogName().hashCode());
        hashCode = 31 * hashCode + (this.schemaName() == null ? 0 : this.schemaName().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.precision() == null ? 0 : this.precision().hashCode());
        hashCode = 31 * hashCode + (this.scale() == null ? 0 : this.scale().hashCode());
        hashCode = 31 * hashCode + (this.nullable() == null ? 0 : this.nullable().hashCode());
        hashCode = 31 * hashCode + (this.caseSensitive() == null ? 0 : this.caseSensitive().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo)obj;
        if (other.catalogName() == null ^ this.catalogName() == null) {
            return false;
        }
        if (other.catalogName() != null && !other.catalogName().equals(this.catalogName())) {
            return false;
        }
        if (other.schemaName() == null ^ this.schemaName() == null) {
            return false;
        }
        if (other.schemaName() != null && !other.schemaName().equals(this.schemaName())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.precision() == null ^ this.precision() == null) {
            return false;
        }
        if (other.precision() != null && !other.precision().equals(this.precision())) {
            return false;
        }
        if (other.scale() == null ^ this.scale() == null) {
            return false;
        }
        if (other.scale() != null && !other.scale().equals(this.scale())) {
            return false;
        }
        if (other.nullable() == null ^ this.nullable() == null) {
            return false;
        }
        if (other.nullable() != null && !other.nullable().equals(this.nullable())) {
            return false;
        }
        if (other.caseSensitive() == null ^ this.caseSensitive() == null) {
            return false;
        }
        return other.caseSensitive() == null || other.caseSensitive().equals(this.caseSensitive());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.catalogName() != null) {
            sb.append("CatalogName: ").append(this.catalogName()).append(",");
        }
        if (this.schemaName() != null) {
            sb.append("SchemaName: ").append(this.schemaName()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.precision() != null) {
            sb.append("Precision: ").append(this.precision()).append(",");
        }
        if (this.scale() != null) {
            sb.append("Scale: ").append(this.scale()).append(",");
        }
        if (this.nullable() != null) {
            sb.append("Nullable: ").append(this.nullable()).append(",");
        }
        if (this.caseSensitive() != null) {
            sb.append("CaseSensitive: ").append(this.caseSensitive()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColumnInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String catalogName;
        private String schemaName;
        private String tableName;
        private String name;
        private String label;
        private String type;
        private Integer precision;
        private Integer scale;
        private String nullable;
        private Boolean caseSensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnInfo model) {
            this.setCatalogName(model.catalogName);
            this.setSchemaName(model.schemaName);
            this.setTableName(model.tableName);
            this.setName(model.name);
            this.setLabel(model.label);
            this.setType(model.type);
            this.setPrecision(model.precision);
            this.setScale(model.scale);
            this.setNullable(model.nullable);
            this.setCaseSensitive(model.caseSensitive);
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getPrecision() {
            return this.precision;
        }

        @Override
        public final Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Integer precision) {
            this.precision = precision;
        }

        public final Integer getScale() {
            return this.scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final String getNullable() {
            return this.nullable;
        }

        @Override
        public final Builder nullable(String nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public final Builder nullable(ColumnNullable nullable) {
            this.nullable(nullable.toString());
            return this;
        }

        public final void setNullable(String nullable) {
            this.nullable = nullable;
        }

        public final Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ColumnInfo> {
        public Builder catalogName(String var1);

        public Builder schemaName(String var1);

        public Builder tableName(String var1);

        public Builder name(String var1);

        public Builder label(String var1);

        public Builder type(String var1);

        public Builder precision(Integer var1);

        public Builder scale(Integer var1);

        public Builder nullable(String var1);

        public Builder nullable(ColumnNullable var1);

        public Builder caseSensitive(Boolean var1);
    }
}

