/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;

@SdkInternalApi
public class EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionOption").build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKey").build();
    private static final EncryptionConfigurationMarshaller instance = new EncryptionConfigurationMarshaller();

    public static EncryptionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionConfiguration encryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (encryptionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryptionConfiguration.encryptionOption(), ENCRYPTIONOPTION_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfiguration.kmsKey(), KMSKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

