/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartQueryExecutionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartQueryExecutionRequest> {
    private final String queryString;
    private final String clientRequestToken;
    private final QueryExecutionContext queryExecutionContext;
    private final ResultConfiguration resultConfiguration;

    private StartQueryExecutionRequest(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.clientRequestToken = builder.clientRequestToken;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.resultConfiguration = builder.resultConfiguration;
    }

    public String queryString() {
        return this.queryString;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryString() == null ? 0 : this.queryString().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.queryExecutionContext() == null ? 0 : this.queryExecutionContext().hashCode());
        hashCode = 31 * hashCode + (this.resultConfiguration() == null ? 0 : this.resultConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryExecutionRequest)) {
            return false;
        }
        StartQueryExecutionRequest other = (StartQueryExecutionRequest)((Object)obj);
        if (other.queryString() == null ^ this.queryString() == null) {
            return false;
        }
        if (other.queryString() != null && !other.queryString().equals(this.queryString())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        if (other.queryExecutionContext() == null ^ this.queryExecutionContext() == null) {
            return false;
        }
        if (other.queryExecutionContext() != null && !other.queryExecutionContext().equals(this.queryExecutionContext())) {
            return false;
        }
        if (other.resultConfiguration() == null ^ this.resultConfiguration() == null) {
            return false;
        }
        return other.resultConfiguration() == null || other.resultConfiguration().equals(this.resultConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryString() != null) {
            sb.append("QueryString: ").append(this.queryString()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (this.queryExecutionContext() != null) {
            sb.append("QueryExecutionContext: ").append(this.queryExecutionContext()).append(",");
        }
        if (this.resultConfiguration() != null) {
            sb.append("ResultConfiguration: ").append(this.resultConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queryString;
        private String clientRequestToken;
        private QueryExecutionContext queryExecutionContext;
        private ResultConfiguration resultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryExecutionRequest model) {
            this.setQueryString(model.queryString);
            this.setClientRequestToken(model.clientRequestToken);
            this.setQueryExecutionContext(model.queryExecutionContext);
            this.setResultConfiguration(model.resultConfiguration);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final QueryExecutionContext getQueryExecutionContext() {
            return this.queryExecutionContext;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final void setQueryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
        }

        public final ResultConfiguration getResultConfiguration() {
            return this.resultConfiguration;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final void setResultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
        }

        public StartQueryExecutionRequest build() {
            return new StartQueryExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartQueryExecutionRequest> {
        public Builder queryString(String var1);

        public Builder clientRequestToken(String var1);

        public Builder queryExecutionContext(QueryExecutionContext var1);

        public Builder resultConfiguration(ResultConfiguration var1);
    }
}

