/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.Row;
import software.amazon.awssdk.services.athena.model.RowListCopier;
import software.amazon.awssdk.services.athena.transform.ResultSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResultSet
implements StructuredPojo,
ToCopyableBuilder<Builder, ResultSet> {
    private final List<Row> rows;
    private final ResultSetMetadata resultSetMetadata;

    private ResultSet(BuilderImpl builder) {
        this.rows = builder.rows;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    public List<Row> rows() {
        return this.rows;
    }

    public ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rows() == null ? 0 : this.rows().hashCode());
        hashCode = 31 * hashCode + (this.resultSetMetadata() == null ? 0 : this.resultSetMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        if (other.rows() == null ^ this.rows() == null) {
            return false;
        }
        if (other.rows() != null && !other.rows().equals(this.rows())) {
            return false;
        }
        if (other.resultSetMetadata() == null ^ this.resultSetMetadata() == null) {
            return false;
        }
        return other.resultSetMetadata() == null || other.resultSetMetadata().equals(this.resultSetMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rows() != null) {
            sb.append("Rows: ").append(this.rows()).append(",");
        }
        if (this.resultSetMetadata() != null) {
            sb.append("ResultSetMetadata: ").append(this.resultSetMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Row> rows;
        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSet model) {
            this.setRows(model.rows);
            this.setResultSetMetadata(model.resultSetMetadata);
        }

        public final Collection<Row> getRows() {
            return this.rows;
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        public final void setRows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
        }

        @SafeVarargs
        public final void setRows(Row ... rows) {
            this.rows(Arrays.asList(rows));
        }

        public final ResultSetMetadata getResultSetMetadata() {
            return this.resultSetMetadata;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        public final void setResultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
        }

        public ResultSet build() {
            return new ResultSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResultSet> {
        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder resultSetMetadata(ResultSetMetadata var1);
    }
}

