/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetQueryExecutionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
    private final List<String> queryExecutionIds;

    private BatchGetQueryExecutionRequest(BuilderImpl builder) {
        this.queryExecutionIds = builder.queryExecutionIds;
    }

    public List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryExecutionIds() == null ? 0 : this.queryExecutionIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionRequest)) {
            return false;
        }
        BatchGetQueryExecutionRequest other = (BatchGetQueryExecutionRequest)((Object)obj);
        if (other.queryExecutionIds() == null ^ this.queryExecutionIds() == null) {
            return false;
        }
        return other.queryExecutionIds() == null || other.queryExecutionIds().equals(this.queryExecutionIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryExecutionIds() != null) {
            sb.append("QueryExecutionIds: ").append(this.queryExecutionIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionRequest model) {
            this.setQueryExecutionIds(model.queryExecutionIds);
        }

        public final Collection<String> getQueryExecutionIds() {
            return this.queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        @SafeVarargs
        public final void setQueryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
        }

        public BatchGetQueryExecutionRequest build() {
            return new BatchGetQueryExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);
    }
}

