/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnprocessedNamedQueryIdMarshaller {
    private static final MarshallingInfo<String> NAMEDQUERYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamedQueryId").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final UnprocessedNamedQueryIdMarshaller INSTANCE = new UnprocessedNamedQueryIdMarshaller();

    private UnprocessedNamedQueryIdMarshaller() {
    }

    public static UnprocessedNamedQueryIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedNamedQueryId unprocessedNamedQueryId, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)unprocessedNamedQueryId, (String)"unprocessedNamedQueryId");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unprocessedNamedQueryId.namedQueryId(), NAMEDQUERYID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedNamedQueryId.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedNamedQueryId.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

