/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.Datum;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DatumMarshaller {
    private static final MarshallingInfo<String> VARCHARVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VarCharValue").isBinary(false).build();
    private static final DatumMarshaller INSTANCE = new DatumMarshaller();

    private DatumMarshaller() {
    }

    public static DatumMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Datum datum, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)datum, (String)"datum");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)datum.varCharValue(), VARCHARVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

