/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetQueryExecutionRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
    private final List<String> queryExecutionIds;

    private BatchGetQueryExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.queryExecutionIds = builder.queryExecutionIds;
    }

    public List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionRequest)) {
            return false;
        }
        BatchGetQueryExecutionRequest other = (BatchGetQueryExecutionRequest)((Object)obj);
        return Objects.equals(this.queryExecutionIds(), other.queryExecutionIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetQueryExecutionRequest").add("QueryExecutionIds", this.queryExecutionIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionIds": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionRequest model) {
            super(model);
            this.queryExecutionIds(model.queryExecutionIds);
        }

        public final Collection<String> getQueryExecutionIds() {
            return this.queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetQueryExecutionRequest build() {
            return new BatchGetQueryExecutionRequest(this);
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    CopyableBuilder<Builder, BatchGetQueryExecutionRequest> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

