/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.NamedQueryIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetNamedQueryRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, BatchGetNamedQueryRequest> {
    private final List<String> namedQueryIds;

    private BatchGetNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryIds = builder.namedQueryIds;
    }

    public List<String> namedQueryIds() {
        return this.namedQueryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namedQueryIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryRequest)) {
            return false;
        }
        BatchGetNamedQueryRequest other = (BatchGetNamedQueryRequest)((Object)obj);
        return Objects.equals(this.namedQueryIds(), other.namedQueryIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetNamedQueryRequest").add("NamedQueryIds", this.namedQueryIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryIds": {
                return Optional.ofNullable(clazz.cast(this.namedQueryIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private List<String> namedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryRequest model) {
            super(model);
            this.namedQueryIds(model.namedQueryIds);
        }

        public final Collection<String> getNamedQueryIds() {
            return this.namedQueryIds;
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String ... namedQueryIds) {
            this.namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetNamedQueryRequest build() {
            return new BatchGetNamedQueryRequest(this);
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    CopyableBuilder<Builder, BatchGetNamedQueryRequest> {
        public Builder namedQueryIds(Collection<String> var1);

        public Builder namedQueryIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

